/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectorEntity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectorEntity> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConnectorEntity.getter(ConnectorEntity::name)).setter(ConnectorEntity.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConnectorEntity.getter(ConnectorEntity::label)).setter(ConnectorEntity.setter(Builder::label)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("label").build()}).build();
    private static final SdkField<Boolean> HAS_NESTED_ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ConnectorEntity.getter(ConnectorEntity::hasNestedEntities)).setter(ConnectorEntity.setter(Builder::hasNestedEntities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hasNestedEntities").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, LABEL_FIELD, HAS_NESTED_ENTITIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String label;
    private final Boolean hasNestedEntities;

    private ConnectorEntity(BuilderImpl builder) {
        this.name = builder.name;
        this.label = builder.label;
        this.hasNestedEntities = builder.hasNestedEntities;
    }

    public String name() {
        return this.name;
    }

    public String label() {
        return this.label;
    }

    public Boolean hasNestedEntities() {
        return this.hasNestedEntities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.label());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNestedEntities());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorEntity)) {
            return false;
        }
        ConnectorEntity other = (ConnectorEntity)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.label(), other.label()) && Objects.equals(this.hasNestedEntities(), other.hasNestedEntities());
    }

    public String toString() {
        return ToString.builder((String)"ConnectorEntity").add("Name", (Object)this.name()).add("Label", (Object)this.label()).add("HasNestedEntities", (Object)this.hasNestedEntities()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "label": {
                return Optional.ofNullable(clazz.cast(this.label()));
            }
            case "hasNestedEntities": {
                return Optional.ofNullable(clazz.cast(this.hasNestedEntities()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectorEntity, T> g) {
        return obj -> g.apply((ConnectorEntity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String label;
        private Boolean hasNestedEntities;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorEntity model) {
            this.name(model.name);
            this.label(model.label);
            this.hasNestedEntities(model.hasNestedEntities);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getLabel() {
            return this.label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        public final Boolean getHasNestedEntities() {
            return this.hasNestedEntities;
        }

        @Override
        public final Builder hasNestedEntities(Boolean hasNestedEntities) {
            this.hasNestedEntities = hasNestedEntities;
            return this;
        }

        public final void setHasNestedEntities(Boolean hasNestedEntities) {
            this.hasNestedEntities = hasNestedEntities;
        }

        public ConnectorEntity build() {
            return new ConnectorEntity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectorEntity> {
        public Builder name(String var1);

        public Builder label(String var1);

        public Builder hasNestedEntities(Boolean var1);
    }
}

