/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.TriggerProperties;
import software.amazon.awssdk.services.appflow.model.TriggerType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TriggerConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TriggerConfig> {
    private static final SdkField<String> TRIGGER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TriggerConfig.getter(TriggerConfig::triggerTypeAsString)).setter(TriggerConfig.setter(Builder::triggerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerType").build()}).build();
    private static final SdkField<TriggerProperties> TRIGGER_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TriggerConfig.getter(TriggerConfig::triggerProperties)).setter(TriggerConfig.setter(Builder::triggerProperties)).constructor(TriggerProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIGGER_TYPE_FIELD, TRIGGER_PROPERTIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String triggerType;
    private final TriggerProperties triggerProperties;

    private TriggerConfig(BuilderImpl builder) {
        this.triggerType = builder.triggerType;
        this.triggerProperties = builder.triggerProperties;
    }

    public TriggerType triggerType() {
        return TriggerType.fromValue(this.triggerType);
    }

    public String triggerTypeAsString() {
        return this.triggerType;
    }

    public TriggerProperties triggerProperties() {
        return this.triggerProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerProperties());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TriggerConfig)) {
            return false;
        }
        TriggerConfig other = (TriggerConfig)obj;
        return Objects.equals(this.triggerTypeAsString(), other.triggerTypeAsString()) && Objects.equals(this.triggerProperties(), other.triggerProperties());
    }

    public String toString() {
        return ToString.builder((String)"TriggerConfig").add("TriggerType", (Object)this.triggerTypeAsString()).add("TriggerProperties", (Object)this.triggerProperties()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "triggerType": {
                return Optional.ofNullable(clazz.cast(this.triggerTypeAsString()));
            }
            case "triggerProperties": {
                return Optional.ofNullable(clazz.cast(this.triggerProperties()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TriggerConfig, T> g) {
        return obj -> g.apply((TriggerConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String triggerType;
        private TriggerProperties triggerProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(TriggerConfig model) {
            this.triggerType(model.triggerType);
            this.triggerProperties(model.triggerProperties);
        }

        public final String getTriggerType() {
            return this.triggerType;
        }

        @Override
        public final Builder triggerType(String triggerType) {
            this.triggerType = triggerType;
            return this;
        }

        @Override
        public final Builder triggerType(TriggerType triggerType) {
            this.triggerType(triggerType == null ? null : triggerType.toString());
            return this;
        }

        public final void setTriggerType(String triggerType) {
            this.triggerType = triggerType;
        }

        public final TriggerProperties.Builder getTriggerProperties() {
            return this.triggerProperties != null ? this.triggerProperties.toBuilder() : null;
        }

        @Override
        public final Builder triggerProperties(TriggerProperties triggerProperties) {
            this.triggerProperties = triggerProperties;
            return this;
        }

        public final void setTriggerProperties(TriggerProperties.BuilderImpl triggerProperties) {
            this.triggerProperties = triggerProperties != null ? triggerProperties.build() : null;
        }

        public TriggerConfig build() {
            return new TriggerConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TriggerConfig> {
        public Builder triggerType(String var1);

        public Builder triggerType(TriggerType var1);

        public Builder triggerProperties(TriggerProperties var1);

        default public Builder triggerProperties(Consumer<TriggerProperties.Builder> triggerProperties) {
            return this.triggerProperties((TriggerProperties)((TriggerProperties.Builder)TriggerProperties.builder().applyMutation(triggerProperties)).build());
        }
    }
}

