/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appflow.model.EventBridgeDestinationProperties;
import software.amazon.awssdk.services.appflow.model.RedshiftDestinationProperties;
import software.amazon.awssdk.services.appflow.model.S3DestinationProperties;
import software.amazon.awssdk.services.appflow.model.SalesforceDestinationProperties;
import software.amazon.awssdk.services.appflow.model.SnowflakeDestinationProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DestinationConnectorProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DestinationConnectorProperties> {
    private static final SdkField<RedshiftDestinationProperties> REDSHIFT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DestinationConnectorProperties.getter(DestinationConnectorProperties::redshift)).setter(DestinationConnectorProperties.setter(Builder::redshift)).constructor(RedshiftDestinationProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Redshift").build()}).build();
    private static final SdkField<S3DestinationProperties> S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DestinationConnectorProperties.getter(DestinationConnectorProperties::s3)).setter(DestinationConnectorProperties.setter(Builder::s3)).constructor(S3DestinationProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3").build()}).build();
    private static final SdkField<SalesforceDestinationProperties> SALESFORCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DestinationConnectorProperties.getter(DestinationConnectorProperties::salesforce)).setter(DestinationConnectorProperties.setter(Builder::salesforce)).constructor(SalesforceDestinationProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Salesforce").build()}).build();
    private static final SdkField<SnowflakeDestinationProperties> SNOWFLAKE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DestinationConnectorProperties.getter(DestinationConnectorProperties::snowflake)).setter(DestinationConnectorProperties.setter(Builder::snowflake)).constructor(SnowflakeDestinationProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Snowflake").build()}).build();
    private static final SdkField<EventBridgeDestinationProperties> EVENT_BRIDGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DestinationConnectorProperties.getter(DestinationConnectorProperties::eventBridge)).setter(DestinationConnectorProperties.setter(Builder::eventBridge)).constructor(EventBridgeDestinationProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBridge").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REDSHIFT_FIELD, S3_FIELD, SALESFORCE_FIELD, SNOWFLAKE_FIELD, EVENT_BRIDGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final RedshiftDestinationProperties redshift;
    private final S3DestinationProperties s3;
    private final SalesforceDestinationProperties salesforce;
    private final SnowflakeDestinationProperties snowflake;
    private final EventBridgeDestinationProperties eventBridge;

    private DestinationConnectorProperties(BuilderImpl builder) {
        this.redshift = builder.redshift;
        this.s3 = builder.s3;
        this.salesforce = builder.salesforce;
        this.snowflake = builder.snowflake;
        this.eventBridge = builder.eventBridge;
    }

    public RedshiftDestinationProperties redshift() {
        return this.redshift;
    }

    public S3DestinationProperties s3() {
        return this.s3;
    }

    public SalesforceDestinationProperties salesforce() {
        return this.salesforce;
    }

    public SnowflakeDestinationProperties snowflake() {
        return this.snowflake;
    }

    public EventBridgeDestinationProperties eventBridge() {
        return this.eventBridge;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.redshift());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3());
        hashCode = 31 * hashCode + Objects.hashCode(this.salesforce());
        hashCode = 31 * hashCode + Objects.hashCode(this.snowflake());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventBridge());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationConnectorProperties)) {
            return false;
        }
        DestinationConnectorProperties other = (DestinationConnectorProperties)obj;
        return Objects.equals(this.redshift(), other.redshift()) && Objects.equals(this.s3(), other.s3()) && Objects.equals(this.salesforce(), other.salesforce()) && Objects.equals(this.snowflake(), other.snowflake()) && Objects.equals(this.eventBridge(), other.eventBridge());
    }

    public String toString() {
        return ToString.builder((String)"DestinationConnectorProperties").add("Redshift", (Object)this.redshift()).add("S3", (Object)this.s3()).add("Salesforce", (Object)this.salesforce()).add("Snowflake", (Object)this.snowflake()).add("EventBridge", (Object)this.eventBridge()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Redshift": {
                return Optional.ofNullable(clazz.cast(this.redshift()));
            }
            case "S3": {
                return Optional.ofNullable(clazz.cast(this.s3()));
            }
            case "Salesforce": {
                return Optional.ofNullable(clazz.cast(this.salesforce()));
            }
            case "Snowflake": {
                return Optional.ofNullable(clazz.cast(this.snowflake()));
            }
            case "EventBridge": {
                return Optional.ofNullable(clazz.cast(this.eventBridge()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DestinationConnectorProperties, T> g) {
        return obj -> g.apply((DestinationConnectorProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RedshiftDestinationProperties redshift;
        private S3DestinationProperties s3;
        private SalesforceDestinationProperties salesforce;
        private SnowflakeDestinationProperties snowflake;
        private EventBridgeDestinationProperties eventBridge;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationConnectorProperties model) {
            this.redshift(model.redshift);
            this.s3(model.s3);
            this.salesforce(model.salesforce);
            this.snowflake(model.snowflake);
            this.eventBridge(model.eventBridge);
        }

        public final RedshiftDestinationProperties.Builder getRedshift() {
            return this.redshift != null ? this.redshift.toBuilder() : null;
        }

        @Override
        public final Builder redshift(RedshiftDestinationProperties redshift) {
            this.redshift = redshift;
            return this;
        }

        public final void setRedshift(RedshiftDestinationProperties.BuilderImpl redshift) {
            this.redshift = redshift != null ? redshift.build() : null;
        }

        public final S3DestinationProperties.Builder getS3() {
            return this.s3 != null ? this.s3.toBuilder() : null;
        }

        @Override
        public final Builder s3(S3DestinationProperties s3) {
            this.s3 = s3;
            return this;
        }

        public final void setS3(S3DestinationProperties.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        public final SalesforceDestinationProperties.Builder getSalesforce() {
            return this.salesforce != null ? this.salesforce.toBuilder() : null;
        }

        @Override
        public final Builder salesforce(SalesforceDestinationProperties salesforce) {
            this.salesforce = salesforce;
            return this;
        }

        public final void setSalesforce(SalesforceDestinationProperties.BuilderImpl salesforce) {
            this.salesforce = salesforce != null ? salesforce.build() : null;
        }

        public final SnowflakeDestinationProperties.Builder getSnowflake() {
            return this.snowflake != null ? this.snowflake.toBuilder() : null;
        }

        @Override
        public final Builder snowflake(SnowflakeDestinationProperties snowflake) {
            this.snowflake = snowflake;
            return this;
        }

        public final void setSnowflake(SnowflakeDestinationProperties.BuilderImpl snowflake) {
            this.snowflake = snowflake != null ? snowflake.build() : null;
        }

        public final EventBridgeDestinationProperties.Builder getEventBridge() {
            return this.eventBridge != null ? this.eventBridge.toBuilder() : null;
        }

        @Override
        public final Builder eventBridge(EventBridgeDestinationProperties eventBridge) {
            this.eventBridge = eventBridge;
            return this;
        }

        public final void setEventBridge(EventBridgeDestinationProperties.BuilderImpl eventBridge) {
            this.eventBridge = eventBridge != null ? eventBridge.build() : null;
        }

        public DestinationConnectorProperties build() {
            return new DestinationConnectorProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DestinationConnectorProperties> {
        public Builder redshift(RedshiftDestinationProperties var1);

        default public Builder redshift(Consumer<RedshiftDestinationProperties.Builder> redshift) {
            return this.redshift((RedshiftDestinationProperties)((RedshiftDestinationProperties.Builder)RedshiftDestinationProperties.builder().applyMutation(redshift)).build());
        }

        public Builder s3(S3DestinationProperties var1);

        default public Builder s3(Consumer<S3DestinationProperties.Builder> s3) {
            return this.s3((S3DestinationProperties)((S3DestinationProperties.Builder)S3DestinationProperties.builder().applyMutation(s3)).build());
        }

        public Builder salesforce(SalesforceDestinationProperties var1);

        default public Builder salesforce(Consumer<SalesforceDestinationProperties.Builder> salesforce) {
            return this.salesforce((SalesforceDestinationProperties)((SalesforceDestinationProperties.Builder)SalesforceDestinationProperties.builder().applyMutation(salesforce)).build());
        }

        public Builder snowflake(SnowflakeDestinationProperties var1);

        default public Builder snowflake(Consumer<SnowflakeDestinationProperties.Builder> snowflake) {
            return this.snowflake((SnowflakeDestinationProperties)((SnowflakeDestinationProperties.Builder)SnowflakeDestinationProperties.builder().applyMutation(snowflake)).build());
        }

        public Builder eventBridge(EventBridgeDestinationProperties var1);

        default public Builder eventBridge(Consumer<EventBridgeDestinationProperties.Builder> eventBridge) {
            return this.eventBridge((EventBridgeDestinationProperties)((EventBridgeDestinationProperties.Builder)EventBridgeDestinationProperties.builder().applyMutation(eventBridge)).build());
        }
    }
}

