/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectorOAuthRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectorOAuthRequest> {
    private static final SdkField<String> AUTH_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConnectorOAuthRequest.getter(ConnectorOAuthRequest::authCode)).setter(ConnectorOAuthRequest.setter(Builder::authCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authCode").build()}).build();
    private static final SdkField<String> REDIRECT_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConnectorOAuthRequest.getter(ConnectorOAuthRequest::redirectUri)).setter(ConnectorOAuthRequest.setter(Builder::redirectUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redirectUri").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_CODE_FIELD, REDIRECT_URI_FIELD));
    private static final long serialVersionUID = 1L;
    private final String authCode;
    private final String redirectUri;

    private ConnectorOAuthRequest(BuilderImpl builder) {
        this.authCode = builder.authCode;
        this.redirectUri = builder.redirectUri;
    }

    public String authCode() {
        return this.authCode;
    }

    public String redirectUri() {
        return this.redirectUri;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.redirectUri());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorOAuthRequest)) {
            return false;
        }
        ConnectorOAuthRequest other = (ConnectorOAuthRequest)obj;
        return Objects.equals(this.authCode(), other.authCode()) && Objects.equals(this.redirectUri(), other.redirectUri());
    }

    public String toString() {
        return ToString.builder((String)"ConnectorOAuthRequest").add("AuthCode", (Object)this.authCode()).add("RedirectUri", (Object)this.redirectUri()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authCode": {
                return Optional.ofNullable(clazz.cast(this.authCode()));
            }
            case "redirectUri": {
                return Optional.ofNullable(clazz.cast(this.redirectUri()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectorOAuthRequest, T> g) {
        return obj -> g.apply((ConnectorOAuthRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String authCode;
        private String redirectUri;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorOAuthRequest model) {
            this.authCode(model.authCode);
            this.redirectUri(model.redirectUri);
        }

        public final String getAuthCode() {
            return this.authCode;
        }

        @Override
        public final Builder authCode(String authCode) {
            this.authCode = authCode;
            return this;
        }

        public final void setAuthCode(String authCode) {
            this.authCode = authCode;
        }

        public final String getRedirectUri() {
            return this.redirectUri;
        }

        @Override
        public final Builder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public final void setRedirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
        }

        public ConnectorOAuthRequest build() {
            return new ConnectorOAuthRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectorOAuthRequest> {
        public Builder authCode(String var1);

        public Builder redirectUri(String var1);
    }
}

