/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appconfig.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appconfig.AppConfigClient;
import software.amazon.awssdk.services.appconfig.model.ListEnvironmentsRequest;
import software.amazon.awssdk.services.appconfig.model.ListEnvironmentsResponse;

public class ListEnvironmentsIterable
implements SdkIterable<ListEnvironmentsResponse> {
    private final AppConfigClient client;
    private final ListEnvironmentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEnvironmentsIterable(AppConfigClient client, ListEnvironmentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEnvironmentsResponseFetcher();
    }

    public Iterator<ListEnvironmentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListEnvironmentsResponseFetcher
    implements SyncPageFetcher<ListEnvironmentsResponse> {
        private ListEnvironmentsResponseFetcher() {
        }

        public boolean hasNextPage(ListEnvironmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEnvironmentsResponse nextPage(ListEnvironmentsResponse previousPage) {
            if (previousPage == null) {
                return ListEnvironmentsIterable.this.client.listEnvironments(ListEnvironmentsIterable.this.firstRequest);
            }
            return ListEnvironmentsIterable.this.client.listEnvironments((ListEnvironmentsRequest)((Object)ListEnvironmentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

