/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetApiMappingRequest
extends ApiGatewayV2Request
implements ToCopyableBuilder<Builder, GetApiMappingRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetApiMappingRequest.getter(GetApiMappingRequest::apiId)).setter(GetApiMappingRequest.setter(Builder::apiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("apiId").build()}).build();
    private static final SdkField<String> API_MAPPING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetApiMappingRequest.getter(GetApiMappingRequest::apiMappingId)).setter(GetApiMappingRequest.setter(Builder::apiMappingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiMappingId").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetApiMappingRequest.getter(GetApiMappingRequest::domainName)).setter(GetApiMappingRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, API_MAPPING_ID_FIELD, DOMAIN_NAME_FIELD));
    private final String apiId;
    private final String apiMappingId;
    private final String domainName;

    private GetApiMappingRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.apiMappingId = builder.apiMappingId;
        this.domainName = builder.domainName;
    }

    public String apiId() {
        return this.apiId;
    }

    public String apiMappingId() {
        return this.apiMappingId;
    }

    public String domainName() {
        return this.domainName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiMappingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApiMappingRequest)) {
            return false;
        }
        GetApiMappingRequest other = (GetApiMappingRequest)((Object)obj);
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.apiMappingId(), other.apiMappingId()) && Objects.equals(this.domainName(), other.domainName());
    }

    public String toString() {
        return ToString.builder((String)"GetApiMappingRequest").add("ApiId", (Object)this.apiId()).add("ApiMappingId", (Object)this.apiMappingId()).add("DomainName", (Object)this.domainName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "ApiMappingId": {
                return Optional.ofNullable(clazz.cast(this.apiMappingId()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetApiMappingRequest, T> g) {
        return obj -> g.apply((GetApiMappingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Request.BuilderImpl
    implements Builder {
        private String apiId;
        private String apiMappingId;
        private String domainName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApiMappingRequest model) {
            super(model);
            this.apiId(model.apiId);
            this.apiMappingId(model.apiMappingId);
            this.domainName(model.domainName);
        }

        public final String getApiId() {
            return this.apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getApiMappingId() {
            return this.apiMappingId;
        }

        @Override
        public final Builder apiMappingId(String apiMappingId) {
            this.apiMappingId = apiMappingId;
            return this;
        }

        public final void setApiMappingId(String apiMappingId) {
            this.apiMappingId = apiMappingId;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetApiMappingRequest build() {
            return new GetApiMappingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetApiMappingRequest> {
        public Builder apiId(String var1);

        public Builder apiMappingId(String var1);

        public Builder domainName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

