/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.services.apigateway.model.ListOfPatchOperationCopier;
import software.amazon.awssdk.services.apigateway.model.PatchOperation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateVpcLinkRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, UpdateVpcLinkRequest> {
    private static final SdkField<String> VPC_LINK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateVpcLinkRequest.getter(UpdateVpcLinkRequest::vpcLinkId)).setter(UpdateVpcLinkRequest.setter(Builder::vpcLinkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("vpclink_id").build()}).build();
    private static final SdkField<List<PatchOperation>> PATCH_OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateVpcLinkRequest.getter(UpdateVpcLinkRequest::patchOperations)).setter(UpdateVpcLinkRequest.setter(Builder::patchOperations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("patchOperations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PatchOperation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_LINK_ID_FIELD, PATCH_OPERATIONS_FIELD));
    private final String vpcLinkId;
    private final List<PatchOperation> patchOperations;

    private UpdateVpcLinkRequest(BuilderImpl builder) {
        super(builder);
        this.vpcLinkId = builder.vpcLinkId;
        this.patchOperations = builder.patchOperations;
    }

    public String vpcLinkId() {
        return this.vpcLinkId;
    }

    public List<PatchOperation> patchOperations() {
        return this.patchOperations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcLinkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.patchOperations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVpcLinkRequest)) {
            return false;
        }
        UpdateVpcLinkRequest other = (UpdateVpcLinkRequest)((Object)obj);
        return Objects.equals(this.vpcLinkId(), other.vpcLinkId()) && Objects.equals(this.patchOperations(), other.patchOperations());
    }

    public String toString() {
        return ToString.builder((String)"UpdateVpcLinkRequest").add("VpcLinkId", (Object)this.vpcLinkId()).add("PatchOperations", this.patchOperations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vpcLinkId": {
                return Optional.ofNullable(clazz.cast(this.vpcLinkId()));
            }
            case "patchOperations": {
                return Optional.ofNullable(clazz.cast(this.patchOperations()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateVpcLinkRequest, T> g) {
        return obj -> g.apply((UpdateVpcLinkRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String vpcLinkId;
        private List<PatchOperation> patchOperations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVpcLinkRequest model) {
            super(model);
            this.vpcLinkId(model.vpcLinkId);
            this.patchOperations(model.patchOperations);
        }

        public final String getVpcLinkId() {
            return this.vpcLinkId;
        }

        @Override
        public final Builder vpcLinkId(String vpcLinkId) {
            this.vpcLinkId = vpcLinkId;
            return this;
        }

        public final void setVpcLinkId(String vpcLinkId) {
            this.vpcLinkId = vpcLinkId;
        }

        public final Collection<PatchOperation.Builder> getPatchOperations() {
            return this.patchOperations != null ? (Collection)this.patchOperations.stream().map(PatchOperation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder patchOperations(Collection<PatchOperation> patchOperations) {
            this.patchOperations = ListOfPatchOperationCopier.copy(patchOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchOperations(PatchOperation ... patchOperations) {
            this.patchOperations(Arrays.asList(patchOperations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchOperations(Consumer<PatchOperation.Builder> ... patchOperations) {
            this.patchOperations(Stream.of(patchOperations).map(c -> (PatchOperation)((PatchOperation.Builder)PatchOperation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPatchOperations(Collection<PatchOperation.BuilderImpl> patchOperations) {
            this.patchOperations = ListOfPatchOperationCopier.copyFromBuilder(patchOperations);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateVpcLinkRequest build() {
            return new UpdateVpcLinkRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateVpcLinkRequest> {
        public Builder vpcLinkId(String var1);

        public Builder patchOperations(Collection<PatchOperation> var1);

        public Builder patchOperations(PatchOperation ... var1);

        public Builder patchOperations(Consumer<PatchOperation.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

