/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AuthorizerType {
    TOKEN("TOKEN"),
    REQUEST("REQUEST"),
    COGNITO_USER_POOLS("COGNITO_USER_POOLS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AuthorizerType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AuthorizerType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AuthorizerType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AuthorizerType> knownValues() {
        return Stream.of(AuthorizerType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

