/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apigateway.ApiGatewayClient;
import software.amazon.awssdk.services.apigateway.model.Deployment;
import software.amazon.awssdk.services.apigateway.model.GetDeploymentsRequest;
import software.amazon.awssdk.services.apigateway.model.GetDeploymentsResponse;

public class GetDeploymentsIterable
implements SdkIterable<GetDeploymentsResponse> {
    private final ApiGatewayClient client;
    private final GetDeploymentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetDeploymentsIterable(ApiGatewayClient client, GetDeploymentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetDeploymentsResponseFetcher();
    }

    public Iterator<GetDeploymentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Deployment> items() {
        Function<GetDeploymentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final GetDeploymentsIterable resume(GetDeploymentsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetDeploymentsIterable(this.client, (GetDeploymentsRequest)((Object)this.firstRequest.toBuilder().position(lastSuccessfulPage.position()).build()));
        }
        return new GetDeploymentsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetDeploymentsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetDeploymentsResponseFetcher
    implements SyncPageFetcher<GetDeploymentsResponse> {
        private GetDeploymentsResponseFetcher() {
        }

        public boolean hasNextPage(GetDeploymentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.position());
        }

        public GetDeploymentsResponse nextPage(GetDeploymentsResponse previousPage) {
            if (previousPage == null) {
                return GetDeploymentsIterable.this.client.getDeployments(GetDeploymentsIterable.this.firstRequest);
            }
            return GetDeploymentsIterable.this.client.getDeployments((GetDeploymentsRequest)((Object)GetDeploymentsIterable.this.firstRequest.toBuilder().position(previousPage.position()).build()));
        }
    }
}

