/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.EndpointConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDomainNameResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, UpdateDomainNameResponse> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDomainNameResponse.getter(UpdateDomainNameResponse::domainName)).setter(UpdateDomainNameResponse.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<String> CERTIFICATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDomainNameResponse.getter(UpdateDomainNameResponse::certificateName)).setter(UpdateDomainNameResponse.setter(Builder::certificateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateName").build()}).build();
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDomainNameResponse.getter(UpdateDomainNameResponse::certificateArn)).setter(UpdateDomainNameResponse.setter(Builder::certificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateArn").build()}).build();
    private static final SdkField<Instant> CERTIFICATE_UPLOAD_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(UpdateDomainNameResponse.getter(UpdateDomainNameResponse::certificateUploadDate)).setter(UpdateDomainNameResponse.setter(Builder::certificateUploadDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateUploadDate").build()}).build();
    private static final SdkField<String> REGIONAL_DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDomainNameResponse.getter(UpdateDomainNameResponse::regionalDomainName)).setter(UpdateDomainNameResponse.setter(Builder::regionalDomainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionalDomainName").build()}).build();
    private static final SdkField<String> REGIONAL_HOSTED_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDomainNameResponse.getter(UpdateDomainNameResponse::regionalHostedZoneId)).setter(UpdateDomainNameResponse.setter(Builder::regionalHostedZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionalHostedZoneId").build()}).build();
    private static final SdkField<String> REGIONAL_CERTIFICATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDomainNameResponse.getter(UpdateDomainNameResponse::regionalCertificateName)).setter(UpdateDomainNameResponse.setter(Builder::regionalCertificateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionalCertificateName").build()}).build();
    private static final SdkField<String> REGIONAL_CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDomainNameResponse.getter(UpdateDomainNameResponse::regionalCertificateArn)).setter(UpdateDomainNameResponse.setter(Builder::regionalCertificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionalCertificateArn").build()}).build();
    private static final SdkField<String> DISTRIBUTION_DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDomainNameResponse.getter(UpdateDomainNameResponse::distributionDomainName)).setter(UpdateDomainNameResponse.setter(Builder::distributionDomainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributionDomainName").build()}).build();
    private static final SdkField<String> DISTRIBUTION_HOSTED_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDomainNameResponse.getter(UpdateDomainNameResponse::distributionHostedZoneId)).setter(UpdateDomainNameResponse.setter(Builder::distributionHostedZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributionHostedZoneId").build()}).build();
    private static final SdkField<EndpointConfiguration> ENDPOINT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateDomainNameResponse.getter(UpdateDomainNameResponse::endpointConfiguration)).setter(UpdateDomainNameResponse.setter(Builder::endpointConfiguration)).constructor(EndpointConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, CERTIFICATE_NAME_FIELD, CERTIFICATE_ARN_FIELD, CERTIFICATE_UPLOAD_DATE_FIELD, REGIONAL_DOMAIN_NAME_FIELD, REGIONAL_HOSTED_ZONE_ID_FIELD, REGIONAL_CERTIFICATE_NAME_FIELD, REGIONAL_CERTIFICATE_ARN_FIELD, DISTRIBUTION_DOMAIN_NAME_FIELD, DISTRIBUTION_HOSTED_ZONE_ID_FIELD, ENDPOINT_CONFIGURATION_FIELD));
    private final String domainName;
    private final String certificateName;
    private final String certificateArn;
    private final Instant certificateUploadDate;
    private final String regionalDomainName;
    private final String regionalHostedZoneId;
    private final String regionalCertificateName;
    private final String regionalCertificateArn;
    private final String distributionDomainName;
    private final String distributionHostedZoneId;
    private final EndpointConfiguration endpointConfiguration;

    private UpdateDomainNameResponse(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.certificateName = builder.certificateName;
        this.certificateArn = builder.certificateArn;
        this.certificateUploadDate = builder.certificateUploadDate;
        this.regionalDomainName = builder.regionalDomainName;
        this.regionalHostedZoneId = builder.regionalHostedZoneId;
        this.regionalCertificateName = builder.regionalCertificateName;
        this.regionalCertificateArn = builder.regionalCertificateArn;
        this.distributionDomainName = builder.distributionDomainName;
        this.distributionHostedZoneId = builder.distributionHostedZoneId;
        this.endpointConfiguration = builder.endpointConfiguration;
    }

    public String domainName() {
        return this.domainName;
    }

    public String certificateName() {
        return this.certificateName;
    }

    public String certificateArn() {
        return this.certificateArn;
    }

    public Instant certificateUploadDate() {
        return this.certificateUploadDate;
    }

    public String regionalDomainName() {
        return this.regionalDomainName;
    }

    public String regionalHostedZoneId() {
        return this.regionalHostedZoneId;
    }

    public String regionalCertificateName() {
        return this.regionalCertificateName;
    }

    public String regionalCertificateArn() {
        return this.regionalCertificateArn;
    }

    public String distributionDomainName() {
        return this.distributionDomainName;
    }

    public String distributionHostedZoneId() {
        return this.distributionHostedZoneId;
    }

    public EndpointConfiguration endpointConfiguration() {
        return this.endpointConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateUploadDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionalDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionalHostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionalCertificateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionalCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.distributionDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.distributionHostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainNameResponse)) {
            return false;
        }
        UpdateDomainNameResponse other = (UpdateDomainNameResponse)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.certificateName(), other.certificateName()) && Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.certificateUploadDate(), other.certificateUploadDate()) && Objects.equals(this.regionalDomainName(), other.regionalDomainName()) && Objects.equals(this.regionalHostedZoneId(), other.regionalHostedZoneId()) && Objects.equals(this.regionalCertificateName(), other.regionalCertificateName()) && Objects.equals(this.regionalCertificateArn(), other.regionalCertificateArn()) && Objects.equals(this.distributionDomainName(), other.distributionDomainName()) && Objects.equals(this.distributionHostedZoneId(), other.distributionHostedZoneId()) && Objects.equals(this.endpointConfiguration(), other.endpointConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"UpdateDomainNameResponse").add("DomainName", (Object)this.domainName()).add("CertificateName", (Object)this.certificateName()).add("CertificateArn", (Object)this.certificateArn()).add("CertificateUploadDate", (Object)this.certificateUploadDate()).add("RegionalDomainName", (Object)this.regionalDomainName()).add("RegionalHostedZoneId", (Object)this.regionalHostedZoneId()).add("RegionalCertificateName", (Object)this.regionalCertificateName()).add("RegionalCertificateArn", (Object)this.regionalCertificateArn()).add("DistributionDomainName", (Object)this.distributionDomainName()).add("DistributionHostedZoneId", (Object)this.distributionHostedZoneId()).add("EndpointConfiguration", (Object)this.endpointConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "certificateName": {
                return Optional.ofNullable(clazz.cast(this.certificateName()));
            }
            case "certificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "certificateUploadDate": {
                return Optional.ofNullable(clazz.cast(this.certificateUploadDate()));
            }
            case "regionalDomainName": {
                return Optional.ofNullable(clazz.cast(this.regionalDomainName()));
            }
            case "regionalHostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.regionalHostedZoneId()));
            }
            case "regionalCertificateName": {
                return Optional.ofNullable(clazz.cast(this.regionalCertificateName()));
            }
            case "regionalCertificateArn": {
                return Optional.ofNullable(clazz.cast(this.regionalCertificateArn()));
            }
            case "distributionDomainName": {
                return Optional.ofNullable(clazz.cast(this.distributionDomainName()));
            }
            case "distributionHostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.distributionHostedZoneId()));
            }
            case "endpointConfiguration": {
                return Optional.ofNullable(clazz.cast(this.endpointConfiguration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDomainNameResponse, T> g) {
        return obj -> g.apply((UpdateDomainNameResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private String domainName;
        private String certificateName;
        private String certificateArn;
        private Instant certificateUploadDate;
        private String regionalDomainName;
        private String regionalHostedZoneId;
        private String regionalCertificateName;
        private String regionalCertificateArn;
        private String distributionDomainName;
        private String distributionHostedZoneId;
        private EndpointConfiguration endpointConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainNameResponse model) {
            super(model);
            this.domainName(model.domainName);
            this.certificateName(model.certificateName);
            this.certificateArn(model.certificateArn);
            this.certificateUploadDate(model.certificateUploadDate);
            this.regionalDomainName(model.regionalDomainName);
            this.regionalHostedZoneId(model.regionalHostedZoneId);
            this.regionalCertificateName(model.regionalCertificateName);
            this.regionalCertificateArn(model.regionalCertificateArn);
            this.distributionDomainName(model.distributionDomainName);
            this.distributionHostedZoneId(model.distributionHostedZoneId);
            this.endpointConfiguration(model.endpointConfiguration);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getCertificateName() {
            return this.certificateName;
        }

        @Override
        public final Builder certificateName(String certificateName) {
            this.certificateName = certificateName;
            return this;
        }

        public final void setCertificateName(String certificateName) {
            this.certificateName = certificateName;
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final Instant getCertificateUploadDate() {
            return this.certificateUploadDate;
        }

        @Override
        public final Builder certificateUploadDate(Instant certificateUploadDate) {
            this.certificateUploadDate = certificateUploadDate;
            return this;
        }

        public final void setCertificateUploadDate(Instant certificateUploadDate) {
            this.certificateUploadDate = certificateUploadDate;
        }

        public final String getRegionalDomainName() {
            return this.regionalDomainName;
        }

        @Override
        public final Builder regionalDomainName(String regionalDomainName) {
            this.regionalDomainName = regionalDomainName;
            return this;
        }

        public final void setRegionalDomainName(String regionalDomainName) {
            this.regionalDomainName = regionalDomainName;
        }

        public final String getRegionalHostedZoneId() {
            return this.regionalHostedZoneId;
        }

        @Override
        public final Builder regionalHostedZoneId(String regionalHostedZoneId) {
            this.regionalHostedZoneId = regionalHostedZoneId;
            return this;
        }

        public final void setRegionalHostedZoneId(String regionalHostedZoneId) {
            this.regionalHostedZoneId = regionalHostedZoneId;
        }

        public final String getRegionalCertificateName() {
            return this.regionalCertificateName;
        }

        @Override
        public final Builder regionalCertificateName(String regionalCertificateName) {
            this.regionalCertificateName = regionalCertificateName;
            return this;
        }

        public final void setRegionalCertificateName(String regionalCertificateName) {
            this.regionalCertificateName = regionalCertificateName;
        }

        public final String getRegionalCertificateArn() {
            return this.regionalCertificateArn;
        }

        @Override
        public final Builder regionalCertificateArn(String regionalCertificateArn) {
            this.regionalCertificateArn = regionalCertificateArn;
            return this;
        }

        public final void setRegionalCertificateArn(String regionalCertificateArn) {
            this.regionalCertificateArn = regionalCertificateArn;
        }

        public final String getDistributionDomainName() {
            return this.distributionDomainName;
        }

        @Override
        public final Builder distributionDomainName(String distributionDomainName) {
            this.distributionDomainName = distributionDomainName;
            return this;
        }

        public final void setDistributionDomainName(String distributionDomainName) {
            this.distributionDomainName = distributionDomainName;
        }

        public final String getDistributionHostedZoneId() {
            return this.distributionHostedZoneId;
        }

        @Override
        public final Builder distributionHostedZoneId(String distributionHostedZoneId) {
            this.distributionHostedZoneId = distributionHostedZoneId;
            return this;
        }

        public final void setDistributionHostedZoneId(String distributionHostedZoneId) {
            this.distributionHostedZoneId = distributionHostedZoneId;
        }

        public final EndpointConfiguration.Builder getEndpointConfiguration() {
            return this.endpointConfiguration != null ? this.endpointConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder endpointConfiguration(EndpointConfiguration endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        public final void setEndpointConfiguration(EndpointConfiguration.BuilderImpl endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration != null ? endpointConfiguration.build() : null;
        }

        @Override
        public UpdateDomainNameResponse build() {
            return new UpdateDomainNameResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDomainNameResponse> {
        public Builder domainName(String var1);

        public Builder certificateName(String var1);

        public Builder certificateArn(String var1);

        public Builder certificateUploadDate(Instant var1);

        public Builder regionalDomainName(String var1);

        public Builder regionalHostedZoneId(String var1);

        public Builder regionalCertificateName(String var1);

        public Builder regionalCertificateArn(String var1);

        public Builder distributionDomainName(String var1);

        public Builder distributionHostedZoneId(String var1);

        public Builder endpointConfiguration(EndpointConfiguration var1);

        default public Builder endpointConfiguration(Consumer<EndpointConfiguration.Builder> endpointConfiguration) {
            return this.endpointConfiguration((EndpointConfiguration)((EndpointConfiguration.Builder)EndpointConfiguration.builder().applyMutation(endpointConfiguration)).build());
        }
    }
}

