/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CanarySettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CanarySettings> {
    private static final SdkField<Double> PERCENT_TRAFFIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("percentTraffic").getter(CanarySettings.getter(CanarySettings::percentTraffic)).setter(CanarySettings.setter(Builder::percentTraffic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("percentTraffic").build()}).build();
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentId").getter(CanarySettings.getter(CanarySettings::deploymentId)).setter(CanarySettings.setter(Builder::deploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()}).build();
    private static final SdkField<Map<String, String>> STAGE_VARIABLE_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("stageVariableOverrides").getter(CanarySettings.getter(CanarySettings::stageVariableOverrides)).setter(CanarySettings.setter(Builder::stageVariableOverrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageVariableOverrides").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> USE_STAGE_CACHE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("useStageCache").getter(CanarySettings.getter(CanarySettings::useStageCache)).setter(CanarySettings.setter(Builder::useStageCache)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useStageCache").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERCENT_TRAFFIC_FIELD, DEPLOYMENT_ID_FIELD, STAGE_VARIABLE_OVERRIDES_FIELD, USE_STAGE_CACHE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double percentTraffic;
    private final String deploymentId;
    private final Map<String, String> stageVariableOverrides;
    private final Boolean useStageCache;

    private CanarySettings(BuilderImpl builder) {
        this.percentTraffic = builder.percentTraffic;
        this.deploymentId = builder.deploymentId;
        this.stageVariableOverrides = builder.stageVariableOverrides;
        this.useStageCache = builder.useStageCache;
    }

    public Double percentTraffic() {
        return this.percentTraffic;
    }

    public String deploymentId() {
        return this.deploymentId;
    }

    public boolean hasStageVariableOverrides() {
        return this.stageVariableOverrides != null && !(this.stageVariableOverrides instanceof SdkAutoConstructMap);
    }

    public Map<String, String> stageVariableOverrides() {
        return this.stageVariableOverrides;
    }

    public Boolean useStageCache() {
        return this.useStageCache;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.percentTraffic());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageVariableOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(this.useStageCache());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanarySettings)) {
            return false;
        }
        CanarySettings other = (CanarySettings)obj;
        return Objects.equals(this.percentTraffic(), other.percentTraffic()) && Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.stageVariableOverrides(), other.stageVariableOverrides()) && Objects.equals(this.useStageCache(), other.useStageCache());
    }

    public String toString() {
        return ToString.builder((String)"CanarySettings").add("PercentTraffic", (Object)this.percentTraffic()).add("DeploymentId", (Object)this.deploymentId()).add("StageVariableOverrides", this.stageVariableOverrides()).add("UseStageCache", (Object)this.useStageCache()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "percentTraffic": {
                return Optional.ofNullable(clazz.cast(this.percentTraffic()));
            }
            case "deploymentId": {
                return Optional.ofNullable(clazz.cast(this.deploymentId()));
            }
            case "stageVariableOverrides": {
                return Optional.ofNullable(clazz.cast(this.stageVariableOverrides()));
            }
            case "useStageCache": {
                return Optional.ofNullable(clazz.cast(this.useStageCache()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CanarySettings, T> g) {
        return obj -> g.apply((CanarySettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double percentTraffic;
        private String deploymentId;
        private Map<String, String> stageVariableOverrides = DefaultSdkAutoConstructMap.getInstance();
        private Boolean useStageCache;

        private BuilderImpl() {
        }

        private BuilderImpl(CanarySettings model) {
            this.percentTraffic(model.percentTraffic);
            this.deploymentId(model.deploymentId);
            this.stageVariableOverrides(model.stageVariableOverrides);
            this.useStageCache(model.useStageCache);
        }

        public final Double getPercentTraffic() {
            return this.percentTraffic;
        }

        @Override
        public final Builder percentTraffic(Double percentTraffic) {
            this.percentTraffic = percentTraffic;
            return this;
        }

        public final void setPercentTraffic(Double percentTraffic) {
            this.percentTraffic = percentTraffic;
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final Map<String, String> getStageVariableOverrides() {
            return this.stageVariableOverrides;
        }

        @Override
        public final Builder stageVariableOverrides(Map<String, String> stageVariableOverrides) {
            this.stageVariableOverrides = MapOfStringToStringCopier.copy(stageVariableOverrides);
            return this;
        }

        public final void setStageVariableOverrides(Map<String, String> stageVariableOverrides) {
            this.stageVariableOverrides = MapOfStringToStringCopier.copy(stageVariableOverrides);
        }

        public final Boolean getUseStageCache() {
            return this.useStageCache;
        }

        @Override
        public final Builder useStageCache(Boolean useStageCache) {
            this.useStageCache = useStageCache;
            return this;
        }

        public final void setUseStageCache(Boolean useStageCache) {
            this.useStageCache = useStageCache;
        }

        public CanarySettings build() {
            return new CanarySettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CanarySettings> {
        public Builder percentTraffic(Double var1);

        public Builder deploymentId(String var1);

        public Builder stageVariableOverrides(Map<String, String> var1);

        public Builder useStageCache(Boolean var1);
    }
}

