/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.apache.internal.impl;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.apache.internal.ApacheHttpRequestConfig;
import software.amazon.awssdk.http.apache.internal.RepeatableInputStreamRequestEntity;
import software.amazon.awssdk.http.apache.internal.utils.ApacheUtils;
import software.amazon.awssdk.utils.NumericUtils;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

@SdkInternalApi
public class ApacheHttpRequestFactory {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final List<String> IGNORE_HEADERS = Arrays.asList("Content-Length", "Host");

    public HttpRequestBase create(SdkHttpFullRequest request, ApacheHttpRequestConfig requestConfig) {
        URI uri = request.getUri();
        HttpRequestBase base = this.createApacheRequest(request, uri.toString());
        this.addHeadersToRequest(base, request);
        this.addRequestConfig(base, request, requestConfig);
        return base;
    }

    private void addRequestConfig(HttpRequestBase base, SdkHttpFullRequest request, ApacheHttpRequestConfig requestConfig) {
        int connectTimeout = NumericUtils.saturatedCast((long)requestConfig.connectionTimeout().toMillis());
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectionRequestTimeout(connectTimeout).setConnectTimeout(connectTimeout).setSocketTimeout(NumericUtils.saturatedCast((long)requestConfig.socketTimeout().toMillis())).setLocalAddress(requestConfig.localAddress());
        if (SdkHttpMethod.PUT == request.method() && requestConfig.expectContinueEnabled()) {
            requestConfigBuilder.setExpectContinueEnabled(true);
        }
        base.setConfig(requestConfigBuilder.build());
    }

    private HttpRequestBase createApacheRequest(SdkHttpFullRequest request, String uri) {
        switch (request.method()) {
            case HEAD: {
                return new HttpHead(uri);
            }
            case GET: {
                return new HttpGet(uri);
            }
            case DELETE: {
                return new HttpDelete(uri);
            }
            case OPTIONS: {
                return new HttpOptions(uri);
            }
            case PATCH: {
                return this.wrapEntity(request, (HttpEntityEnclosingRequestBase)new HttpPatch(uri));
            }
            case POST: {
                return this.wrapEntity(request, (HttpEntityEnclosingRequestBase)new HttpPost(uri));
            }
            case PUT: {
                return this.wrapEntity(request, (HttpEntityEnclosingRequestBase)new HttpPut(uri));
            }
        }
        throw new RuntimeException("Unknown HTTP method name: " + request.method());
    }

    private HttpRequestBase wrapEntity(SdkHttpFullRequest request, HttpEntityEnclosingRequestBase entityEnclosingRequest) {
        if (request.content().isPresent()) {
            RepeatableInputStreamRequestEntity entity = new RepeatableInputStreamRequestEntity(request);
            if (request.headers().get("Content-Length") == null) {
                entity = ApacheUtils.newBufferedHttpEntity((HttpEntity)entity);
            }
            entityEnclosingRequest.setEntity((HttpEntity)entity);
        }
        return entityEnclosingRequest;
    }

    private void addHeadersToRequest(HttpRequestBase httpRequest, SdkHttpFullRequest request) {
        httpRequest.addHeader("Host", this.getHostHeaderValue((SdkHttpRequest)request));
        request.headers().entrySet().stream().filter(e -> !IGNORE_HEADERS.contains(e.getKey())).forEach(e -> ((List)e.getValue()).forEach(h -> httpRequest.addHeader((String)e.getKey(), h)));
        if (httpRequest.getHeaders("Content-Type") == null || httpRequest.getHeaders("Content-Type").length == 0) {
            httpRequest.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + StringUtils.lowerCase((String)DEFAULT_ENCODING));
        }
    }

    private String getHostHeaderValue(SdkHttpRequest request) {
        return !SdkHttpUtils.isUsingStandardPort((String)request.protocol(), (Integer)request.port()) ? request.host() + ":" + request.port() : request.host();
    }
}

