/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.amplifyuibuilder.model.FieldInputConfig;
import software.amazon.awssdk.services.amplifyuibuilder.model.FieldPosition;
import software.amazon.awssdk.services.amplifyuibuilder.model.FieldValidationConfiguration;
import software.amazon.awssdk.services.amplifyuibuilder.model.ValidationsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FieldConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FieldConfig> {
    private static final SdkField<String> LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("label").getter(FieldConfig.getter(FieldConfig::label)).setter(FieldConfig.setter(Builder::label)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("label").build()}).build();
    private static final SdkField<FieldPosition> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("position").getter(FieldConfig.getter(FieldConfig::position)).setter(FieldConfig.setter(Builder::position)).constructor(FieldPosition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()}).build();
    private static final SdkField<Boolean> EXCLUDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("excluded").getter(FieldConfig.getter(FieldConfig::excluded)).setter(FieldConfig.setter(Builder::excluded)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excluded").build()}).build();
    private static final SdkField<FieldInputConfig> INPUT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inputType").getter(FieldConfig.getter(FieldConfig::inputType)).setter(FieldConfig.setter(Builder::inputType)).constructor(FieldInputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputType").build()}).build();
    private static final SdkField<List<FieldValidationConfiguration>> VALIDATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("validations").getter(FieldConfig.getter(FieldConfig::validations)).setter(FieldConfig.setter(Builder::validations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FieldValidationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_FIELD, POSITION_FIELD, EXCLUDED_FIELD, INPUT_TYPE_FIELD, VALIDATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FieldConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String label;
    private final FieldPosition position;
    private final Boolean excluded;
    private final FieldInputConfig inputType;
    private final List<FieldValidationConfiguration> validations;

    private FieldConfig(BuilderImpl builder) {
        this.label = builder.label;
        this.position = builder.position;
        this.excluded = builder.excluded;
        this.inputType = builder.inputType;
        this.validations = builder.validations;
    }

    public final String label() {
        return this.label;
    }

    public final FieldPosition position() {
        return this.position;
    }

    public final Boolean excluded() {
        return this.excluded;
    }

    public final FieldInputConfig inputType() {
        return this.inputType;
    }

    public final boolean hasValidations() {
        return this.validations != null && !(this.validations instanceof SdkAutoConstructList);
    }

    public final List<FieldValidationConfiguration> validations() {
        return this.validations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.label());
        hashCode = 31 * hashCode + Objects.hashCode(this.position());
        hashCode = 31 * hashCode + Objects.hashCode(this.excluded());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidations() ? this.validations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldConfig)) {
            return false;
        }
        FieldConfig other = (FieldConfig)obj;
        return Objects.equals(this.label(), other.label()) && Objects.equals(this.position(), other.position()) && Objects.equals(this.excluded(), other.excluded()) && Objects.equals(this.inputType(), other.inputType()) && this.hasValidations() == other.hasValidations() && Objects.equals(this.validations(), other.validations());
    }

    public final String toString() {
        return ToString.builder((String)"FieldConfig").add("Label", (Object)this.label()).add("Position", (Object)this.position()).add("Excluded", (Object)this.excluded()).add("InputType", (Object)this.inputType()).add("Validations", this.hasValidations() ? this.validations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "label": {
                return Optional.ofNullable(clazz.cast(this.label()));
            }
            case "position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
            case "excluded": {
                return Optional.ofNullable(clazz.cast(this.excluded()));
            }
            case "inputType": {
                return Optional.ofNullable(clazz.cast(this.inputType()));
            }
            case "validations": {
                return Optional.ofNullable(clazz.cast(this.validations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("label", LABEL_FIELD);
        map.put("position", POSITION_FIELD);
        map.put("excluded", EXCLUDED_FIELD);
        map.put("inputType", INPUT_TYPE_FIELD);
        map.put("validations", VALIDATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FieldConfig, T> g) {
        return obj -> g.apply((FieldConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String label;
        private FieldPosition position;
        private Boolean excluded;
        private FieldInputConfig inputType;
        private List<FieldValidationConfiguration> validations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FieldConfig model) {
            this.label(model.label);
            this.position(model.position);
            this.excluded(model.excluded);
            this.inputType(model.inputType);
            this.validations(model.validations);
        }

        public final String getLabel() {
            return this.label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final FieldPosition.Builder getPosition() {
            return this.position != null ? this.position.toBuilder() : null;
        }

        public final void setPosition(FieldPosition.BuilderImpl position) {
            this.position = position != null ? position.build() : null;
        }

        @Override
        public final Builder position(FieldPosition position) {
            this.position = position;
            return this;
        }

        public final Boolean getExcluded() {
            return this.excluded;
        }

        public final void setExcluded(Boolean excluded) {
            this.excluded = excluded;
        }

        @Override
        public final Builder excluded(Boolean excluded) {
            this.excluded = excluded;
            return this;
        }

        public final FieldInputConfig.Builder getInputType() {
            return this.inputType != null ? this.inputType.toBuilder() : null;
        }

        public final void setInputType(FieldInputConfig.BuilderImpl inputType) {
            this.inputType = inputType != null ? inputType.build() : null;
        }

        @Override
        public final Builder inputType(FieldInputConfig inputType) {
            this.inputType = inputType;
            return this;
        }

        public final List<FieldValidationConfiguration.Builder> getValidations() {
            List<FieldValidationConfiguration.Builder> result = ValidationsListCopier.copyToBuilder(this.validations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValidations(Collection<FieldValidationConfiguration.BuilderImpl> validations) {
            this.validations = ValidationsListCopier.copyFromBuilder(validations);
        }

        @Override
        public final Builder validations(Collection<FieldValidationConfiguration> validations) {
            this.validations = ValidationsListCopier.copy(validations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validations(FieldValidationConfiguration ... validations) {
            this.validations(Arrays.asList(validations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validations(Consumer<FieldValidationConfiguration.Builder> ... validations) {
            this.validations(Stream.of(validations).map(c -> (FieldValidationConfiguration)((FieldValidationConfiguration.Builder)FieldValidationConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public FieldConfig build() {
            return new FieldConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FieldConfig> {
        public Builder label(String var1);

        public Builder position(FieldPosition var1);

        default public Builder position(Consumer<FieldPosition.Builder> position) {
            return this.position((FieldPosition)((FieldPosition.Builder)FieldPosition.builder().applyMutation(position)).build());
        }

        public Builder excluded(Boolean var1);

        public Builder inputType(FieldInputConfig var1);

        default public Builder inputType(Consumer<FieldInputConfig.Builder> inputType) {
            return this.inputType((FieldInputConfig)((FieldInputConfig.Builder)FieldInputConfig.builder().applyMutation(inputType)).build());
        }

        public Builder validations(Collection<FieldValidationConfiguration> var1);

        public Builder validations(FieldValidationConfiguration ... var1);

        public Builder validations(Consumer<FieldValidationConfiguration.Builder> ... var1);
    }
}

