/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amplifyuibuilder.model.AmplifyUiBuilderResponse;
import software.amazon.awssdk.services.amplifyuibuilder.model.FeaturesMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMetadataResponse
extends AmplifyUiBuilderResponse
implements ToCopyableBuilder<Builder, GetMetadataResponse> {
    private static final SdkField<Map<String, String>> FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("features").getter(GetMetadataResponse.getter(GetMetadataResponse::features)).setter(GetMetadataResponse.setter(Builder::features)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("features").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetMetadataResponse.memberNameToFieldInitializer();
    private final Map<String, String> features;

    private GetMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.features = builder.features;
    }

    public final boolean hasFeatures() {
        return this.features != null && !(this.features instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> features() {
        return this.features;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeatures() ? this.features() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetadataResponse)) {
            return false;
        }
        GetMetadataResponse other = (GetMetadataResponse)((Object)obj);
        return this.hasFeatures() == other.hasFeatures() && Objects.equals(this.features(), other.features());
    }

    public final String toString() {
        return ToString.builder((String)"GetMetadataResponse").add("Features", this.hasFeatures() ? this.features() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "features": {
                return Optional.ofNullable(clazz.cast(this.features()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Map<String, String>>> map = new HashMap<String, SdkField<Map<String, String>>>();
        map.put("features", FEATURES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMetadataResponse, T> g) {
        return obj -> g.apply((GetMetadataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyUiBuilderResponse.BuilderImpl
    implements Builder {
        private Map<String, String> features = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetadataResponse model) {
            super(model);
            this.features(model.features);
        }

        public final Map<String, String> getFeatures() {
            if (this.features instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.features;
        }

        public final void setFeatures(Map<String, String> features) {
            this.features = FeaturesMapCopier.copy(features);
        }

        @Override
        public final Builder features(Map<String, String> features) {
            this.features = FeaturesMapCopier.copy(features);
            return this;
        }

        @Override
        public GetMetadataResponse build() {
            return new GetMetadataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AmplifyUiBuilderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMetadataResponse> {
        public Builder features(Map<String, String> var1);
    }
}

