/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.amplifyuibuilder.model.PredicateListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Predicate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Predicate> {
    private static final SdkField<List<Predicate>> OR_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("or").getter(Predicate.getter(Predicate::or)).setter(Predicate.setter(Builder::or)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("or").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Predicate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Predicate>> AND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("and").getter(Predicate.getter(Predicate::and)).setter(Predicate.setter(Builder::and)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("and").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Predicate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("field").getter(Predicate.getter(Predicate::field)).setter(Predicate.setter(Builder::field)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("field").build()}).build();
    private static final SdkField<String> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operator").getter(Predicate.getter(Predicate::operator)).setter(Predicate.setter(Builder::operator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operator").build()}).build();
    private static final SdkField<String> OPERAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operand").getter(Predicate.getter(Predicate::operand)).setter(Predicate.setter(Builder::operand)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operand").build()}).build();
    private static final SdkField<String> OPERAND_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operandType").getter(Predicate.getter(Predicate::operandType)).setter(Predicate.setter(Builder::operandType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operandType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OR_FIELD, AND_FIELD, FIELD_FIELD, OPERATOR_FIELD, OPERAND_FIELD, OPERAND_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Predicate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Predicate> or;
    private final List<Predicate> and;
    private final String field;
    private final String operator;
    private final String operand;
    private final String operandType;

    private Predicate(BuilderImpl builder) {
        this.or = builder.or;
        this.and = builder.and;
        this.field = builder.field;
        this.operator = builder.operator;
        this.operand = builder.operand;
        this.operandType = builder.operandType;
    }

    public final boolean hasOr() {
        return this.or != null && !(this.or instanceof SdkAutoConstructList);
    }

    public final List<Predicate> or() {
        return this.or;
    }

    public final boolean hasAnd() {
        return this.and != null && !(this.and instanceof SdkAutoConstructList);
    }

    public final List<Predicate> and() {
        return this.and;
    }

    public final String field() {
        return this.field;
    }

    public final String operator() {
        return this.operator;
    }

    public final String operand() {
        return this.operand;
    }

    public final String operandType() {
        return this.operandType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOr() ? this.or() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnd() ? this.and() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.field());
        hashCode = 31 * hashCode + Objects.hashCode(this.operator());
        hashCode = 31 * hashCode + Objects.hashCode(this.operand());
        hashCode = 31 * hashCode + Objects.hashCode(this.operandType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Predicate)) {
            return false;
        }
        Predicate other = (Predicate)obj;
        return this.hasOr() == other.hasOr() && Objects.equals(this.or(), other.or()) && this.hasAnd() == other.hasAnd() && Objects.equals(this.and(), other.and()) && Objects.equals(this.field(), other.field()) && Objects.equals(this.operator(), other.operator()) && Objects.equals(this.operand(), other.operand()) && Objects.equals(this.operandType(), other.operandType());
    }

    public final String toString() {
        return ToString.builder((String)"Predicate").add("Or", this.hasOr() ? this.or() : null).add("And", this.hasAnd() ? this.and() : null).add("Field", (Object)this.field()).add("Operator", (Object)this.operator()).add("Operand", (Object)this.operand()).add("OperandType", (Object)this.operandType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "or": {
                return Optional.ofNullable(clazz.cast(this.or()));
            }
            case "and": {
                return Optional.ofNullable(clazz.cast(this.and()));
            }
            case "field": {
                return Optional.ofNullable(clazz.cast(this.field()));
            }
            case "operator": {
                return Optional.ofNullable(clazz.cast(this.operator()));
            }
            case "operand": {
                return Optional.ofNullable(clazz.cast(this.operand()));
            }
            case "operandType": {
                return Optional.ofNullable(clazz.cast(this.operandType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("or", OR_FIELD);
        map.put("and", AND_FIELD);
        map.put("field", FIELD_FIELD);
        map.put("operator", OPERATOR_FIELD);
        map.put("operand", OPERAND_FIELD);
        map.put("operandType", OPERAND_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Predicate, T> g) {
        return obj -> g.apply((Predicate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Predicate> or = DefaultSdkAutoConstructList.getInstance();
        private List<Predicate> and = DefaultSdkAutoConstructList.getInstance();
        private String field;
        private String operator;
        private String operand;
        private String operandType;

        private BuilderImpl() {
        }

        private BuilderImpl(Predicate model) {
            this.or(model.or);
            this.and(model.and);
            this.field(model.field);
            this.operator(model.operator);
            this.operand(model.operand);
            this.operandType(model.operandType);
        }

        public final List<Builder> getOr() {
            List<Builder> result = PredicateListCopier.copyToBuilder(this.or);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOr(Collection<BuilderImpl> or) {
            this.or = PredicateListCopier.copyFromBuilder(or);
        }

        @Override
        public final Builder or(Collection<Predicate> or) {
            this.or = PredicateListCopier.copy(or);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder or(Predicate ... or) {
            this.or(Arrays.asList(or));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder or(Consumer<Builder> ... or) {
            this.or(Stream.of(or).map(c -> (Predicate)((Builder)Predicate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Builder> getAnd() {
            List<Builder> result = PredicateListCopier.copyToBuilder(this.and);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnd(Collection<BuilderImpl> and) {
            this.and = PredicateListCopier.copyFromBuilder(and);
        }

        @Override
        public final Builder and(Collection<Predicate> and) {
            this.and = PredicateListCopier.copy(and);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder and(Predicate ... and) {
            this.and(Arrays.asList(and));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder and(Consumer<Builder> ... and) {
            this.and(Stream.of(and).map(c -> (Predicate)((Builder)Predicate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getField() {
            return this.field;
        }

        public final void setField(String field) {
            this.field = field;
        }

        @Override
        public final Builder field(String field) {
            this.field = field;
            return this;
        }

        public final String getOperator() {
            return this.operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        public final String getOperand() {
            return this.operand;
        }

        public final void setOperand(String operand) {
            this.operand = operand;
        }

        @Override
        public final Builder operand(String operand) {
            this.operand = operand;
            return this;
        }

        public final String getOperandType() {
            return this.operandType;
        }

        public final void setOperandType(String operandType) {
            this.operandType = operandType;
        }

        @Override
        public final Builder operandType(String operandType) {
            this.operandType = operandType;
            return this;
        }

        public Predicate build() {
            return new Predicate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Predicate> {
        public Builder or(Collection<Predicate> var1);

        public Builder or(Predicate ... var1);

        public Builder or(Consumer<Builder> ... var1);

        public Builder and(Collection<Predicate> var1);

        public Builder and(Predicate ... var1);

        public Builder and(Consumer<Builder> ... var1);

        public Builder field(String var1);

        public Builder operator(String var1);

        public Builder operand(String var1);

        public Builder operandType(String var1);
    }
}

