/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifyuibuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.amplifyuibuilder.AmplifyUiBuilderClient;
import software.amazon.awssdk.services.amplifyuibuilder.model.FormSummary;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListFormsRequest;
import software.amazon.awssdk.services.amplifyuibuilder.model.ListFormsResponse;

public class ListFormsIterable
implements SdkIterable<ListFormsResponse> {
    private final AmplifyUiBuilderClient client;
    private final ListFormsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFormsIterable(AmplifyUiBuilderClient client, ListFormsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListFormsResponseFetcher();
    }

    public Iterator<ListFormsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FormSummary> entities() {
        Function<ListFormsResponse, Iterator> getIterator = response -> {
            if (response != null && response.entities() != null) {
                return response.entities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFormsResponseFetcher
    implements SyncPageFetcher<ListFormsResponse> {
        private ListFormsResponseFetcher() {
        }

        public boolean hasNextPage(ListFormsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFormsResponse nextPage(ListFormsResponse previousPage) {
            if (previousPage == null) {
                return ListFormsIterable.this.client.listForms(ListFormsIterable.this.firstRequest);
            }
            return ListFormsIterable.this.client.listForms((ListFormsRequest)((Object)ListFormsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

