/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartCodegenJobRequest extends AmplifyUiBuilderRequest implements
        ToCopyableBuilder<StartCodegenJobRequest.Builder, StartCodegenJobRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appId")
            .getter(getter(StartCodegenJobRequest::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()).build();

    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentName").getter(getter(StartCodegenJobRequest::environmentName))
            .setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentName").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(StartCodegenJobRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<StartCodegenJobData> CODEGEN_JOB_TO_CREATE_FIELD = SdkField
            .<StartCodegenJobData> builder(MarshallingType.SDK_POJO)
            .memberName("codegenJobToCreate")
            .getter(getter(StartCodegenJobRequest::codegenJobToCreate))
            .setter(setter(Builder::codegenJobToCreate))
            .constructor(StartCodegenJobData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codegenJobToCreate").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD,
            ENVIRONMENT_NAME_FIELD, CLIENT_TOKEN_FIELD, CODEGEN_JOB_TO_CREATE_FIELD));

    private final String appId;

    private final String environmentName;

    private final String clientToken;

    private final StartCodegenJobData codegenJobToCreate;

    private StartCodegenJobRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.environmentName = builder.environmentName;
        this.clientToken = builder.clientToken;
        this.codegenJobToCreate = builder.codegenJobToCreate;
    }

    /**
     * <p>
     * The unique ID for the Amplify app.
     * </p>
     * 
     * @return The unique ID for the Amplify app.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * The name of the backend environment that is a part of the Amplify app.
     * </p>
     * 
     * @return The name of the backend environment that is a part of the Amplify app.
     */
    public final String environmentName() {
        return environmentName;
    }

    /**
     * <p>
     * The idempotency token used to ensure that the code generation job request completes only once.
     * </p>
     * 
     * @return The idempotency token used to ensure that the code generation job request completes only once.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The code generation job resource configuration.
     * </p>
     * 
     * @return The code generation job resource configuration.
     */
    public final StartCodegenJobData codegenJobToCreate() {
        return codegenJobToCreate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(codegenJobToCreate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCodegenJobRequest)) {
            return false;
        }
        StartCodegenJobRequest other = (StartCodegenJobRequest) obj;
        return Objects.equals(appId(), other.appId()) && Objects.equals(environmentName(), other.environmentName())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(codegenJobToCreate(), other.codegenJobToCreate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartCodegenJobRequest").add("AppId", appId()).add("EnvironmentName", environmentName())
                .add("ClientToken", clientToken()).add("CodegenJobToCreate", codegenJobToCreate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "environmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "codegenJobToCreate":
            return Optional.ofNullable(clazz.cast(codegenJobToCreate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartCodegenJobRequest, T> g) {
        return obj -> g.apply((StartCodegenJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyUiBuilderRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartCodegenJobRequest> {
        /**
         * <p>
         * The unique ID for the Amplify app.
         * </p>
         * 
         * @param appId
         *        The unique ID for the Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The name of the backend environment that is a part of the Amplify app.
         * </p>
         * 
         * @param environmentName
         *        The name of the backend environment that is a part of the Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * The idempotency token used to ensure that the code generation job request completes only once.
         * </p>
         * 
         * @param clientToken
         *        The idempotency token used to ensure that the code generation job request completes only once.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The code generation job resource configuration.
         * </p>
         * 
         * @param codegenJobToCreate
         *        The code generation job resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codegenJobToCreate(StartCodegenJobData codegenJobToCreate);

        /**
         * <p>
         * The code generation job resource configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link StartCodegenJobData.Builder} avoiding the
         * need to create one manually via {@link StartCodegenJobData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StartCodegenJobData.Builder#build()} is called immediately and
         * its result is passed to {@link #codegenJobToCreate(StartCodegenJobData)}.
         * 
         * @param codegenJobToCreate
         *        a consumer that will call methods on {@link StartCodegenJobData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codegenJobToCreate(StartCodegenJobData)
         */
        default Builder codegenJobToCreate(Consumer<StartCodegenJobData.Builder> codegenJobToCreate) {
            return codegenJobToCreate(StartCodegenJobData.builder().applyMutation(codegenJobToCreate).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AmplifyUiBuilderRequest.BuilderImpl implements Builder {
        private String appId;

        private String environmentName;

        private String clientToken;

        private StartCodegenJobData codegenJobToCreate;

        private BuilderImpl() {
        }

        private BuilderImpl(StartCodegenJobRequest model) {
            super(model);
            appId(model.appId);
            environmentName(model.environmentName);
            clientToken(model.clientToken);
            codegenJobToCreate(model.codegenJobToCreate);
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final StartCodegenJobData.Builder getCodegenJobToCreate() {
            return codegenJobToCreate != null ? codegenJobToCreate.toBuilder() : null;
        }

        public final void setCodegenJobToCreate(StartCodegenJobData.BuilderImpl codegenJobToCreate) {
            this.codegenJobToCreate = codegenJobToCreate != null ? codegenJobToCreate.build() : null;
        }

        @Override
        public final Builder codegenJobToCreate(StartCodegenJobData codegenJobToCreate) {
            this.codegenJobToCreate = codegenJobToCreate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartCodegenJobRequest build() {
            return new StartCodegenJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
