/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifyuibuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the code generation job configuration for a React project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReactStartCodegenJobData implements SdkPojo, Serializable,
        ToCopyableBuilder<ReactStartCodegenJobData.Builder, ReactStartCodegenJobData> {
    private static final SdkField<String> MODULE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("module")
            .getter(getter(ReactStartCodegenJobData::moduleAsString)).setter(setter(Builder::module))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("module").build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("target")
            .getter(getter(ReactStartCodegenJobData::targetAsString)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final SdkField<String> SCRIPT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("script")
            .getter(getter(ReactStartCodegenJobData::scriptAsString)).setter(setter(Builder::script))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("script").build()).build();

    private static final SdkField<Boolean> RENDER_TYPE_DECLARATIONS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("renderTypeDeclarations").getter(getter(ReactStartCodegenJobData::renderTypeDeclarations))
            .setter(setter(Builder::renderTypeDeclarations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renderTypeDeclarations").build())
            .build();

    private static final SdkField<Boolean> INLINE_SOURCE_MAP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("inlineSourceMap").getter(getter(ReactStartCodegenJobData::inlineSourceMap))
            .setter(setter(Builder::inlineSourceMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inlineSourceMap").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODULE_FIELD, TARGET_FIELD,
            SCRIPT_FIELD, RENDER_TYPE_DECLARATIONS_FIELD, INLINE_SOURCE_MAP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String module;

    private final String target;

    private final String script;

    private final Boolean renderTypeDeclarations;

    private final Boolean inlineSourceMap;

    private ReactStartCodegenJobData(BuilderImpl builder) {
        this.module = builder.module;
        this.target = builder.target;
        this.script = builder.script;
        this.renderTypeDeclarations = builder.renderTypeDeclarations;
        this.inlineSourceMap = builder.inlineSourceMap;
    }

    /**
     * <p>
     * The JavaScript module type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #module} will
     * return {@link JSModule#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #moduleAsString}.
     * </p>
     * 
     * @return The JavaScript module type.
     * @see JSModule
     */
    public final JSModule module() {
        return JSModule.fromValue(module);
    }

    /**
     * <p>
     * The JavaScript module type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #module} will
     * return {@link JSModule#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #moduleAsString}.
     * </p>
     * 
     * @return The JavaScript module type.
     * @see JSModule
     */
    public final String moduleAsString() {
        return module;
    }

    /**
     * <p>
     * The ECMAScript specification to use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #target} will
     * return {@link JSTarget#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetAsString}.
     * </p>
     * 
     * @return The ECMAScript specification to use.
     * @see JSTarget
     */
    public final JSTarget target() {
        return JSTarget.fromValue(target);
    }

    /**
     * <p>
     * The ECMAScript specification to use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #target} will
     * return {@link JSTarget#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetAsString}.
     * </p>
     * 
     * @return The ECMAScript specification to use.
     * @see JSTarget
     */
    public final String targetAsString() {
        return target;
    }

    /**
     * <p>
     * The file type to use for a JavaScript project.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #script} will
     * return {@link JSScript#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scriptAsString}.
     * </p>
     * 
     * @return The file type to use for a JavaScript project.
     * @see JSScript
     */
    public final JSScript script() {
        return JSScript.fromValue(script);
    }

    /**
     * <p>
     * The file type to use for a JavaScript project.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #script} will
     * return {@link JSScript#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scriptAsString}.
     * </p>
     * 
     * @return The file type to use for a JavaScript project.
     * @see JSScript
     */
    public final String scriptAsString() {
        return script;
    }

    /**
     * <p>
     * Specifies whether the code generation job should render type declaration files.
     * </p>
     * 
     * @return Specifies whether the code generation job should render type declaration files.
     */
    public final Boolean renderTypeDeclarations() {
        return renderTypeDeclarations;
    }

    /**
     * <p>
     * Specifies whether the code generation job should render inline source maps.
     * </p>
     * 
     * @return Specifies whether the code generation job should render inline source maps.
     */
    public final Boolean inlineSourceMap() {
        return inlineSourceMap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(moduleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scriptAsString());
        hashCode = 31 * hashCode + Objects.hashCode(renderTypeDeclarations());
        hashCode = 31 * hashCode + Objects.hashCode(inlineSourceMap());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReactStartCodegenJobData)) {
            return false;
        }
        ReactStartCodegenJobData other = (ReactStartCodegenJobData) obj;
        return Objects.equals(moduleAsString(), other.moduleAsString())
                && Objects.equals(targetAsString(), other.targetAsString())
                && Objects.equals(scriptAsString(), other.scriptAsString())
                && Objects.equals(renderTypeDeclarations(), other.renderTypeDeclarations())
                && Objects.equals(inlineSourceMap(), other.inlineSourceMap());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReactStartCodegenJobData").add("Module", moduleAsString()).add("Target", targetAsString())
                .add("Script", scriptAsString()).add("RenderTypeDeclarations", renderTypeDeclarations())
                .add("InlineSourceMap", inlineSourceMap()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "module":
            return Optional.ofNullable(clazz.cast(moduleAsString()));
        case "target":
            return Optional.ofNullable(clazz.cast(targetAsString()));
        case "script":
            return Optional.ofNullable(clazz.cast(scriptAsString()));
        case "renderTypeDeclarations":
            return Optional.ofNullable(clazz.cast(renderTypeDeclarations()));
        case "inlineSourceMap":
            return Optional.ofNullable(clazz.cast(inlineSourceMap()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReactStartCodegenJobData, T> g) {
        return obj -> g.apply((ReactStartCodegenJobData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReactStartCodegenJobData> {
        /**
         * <p>
         * The JavaScript module type.
         * </p>
         * 
         * @param module
         *        The JavaScript module type.
         * @see JSModule
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JSModule
         */
        Builder module(String module);

        /**
         * <p>
         * The JavaScript module type.
         * </p>
         * 
         * @param module
         *        The JavaScript module type.
         * @see JSModule
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JSModule
         */
        Builder module(JSModule module);

        /**
         * <p>
         * The ECMAScript specification to use.
         * </p>
         * 
         * @param target
         *        The ECMAScript specification to use.
         * @see JSTarget
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JSTarget
         */
        Builder target(String target);

        /**
         * <p>
         * The ECMAScript specification to use.
         * </p>
         * 
         * @param target
         *        The ECMAScript specification to use.
         * @see JSTarget
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JSTarget
         */
        Builder target(JSTarget target);

        /**
         * <p>
         * The file type to use for a JavaScript project.
         * </p>
         * 
         * @param script
         *        The file type to use for a JavaScript project.
         * @see JSScript
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JSScript
         */
        Builder script(String script);

        /**
         * <p>
         * The file type to use for a JavaScript project.
         * </p>
         * 
         * @param script
         *        The file type to use for a JavaScript project.
         * @see JSScript
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JSScript
         */
        Builder script(JSScript script);

        /**
         * <p>
         * Specifies whether the code generation job should render type declaration files.
         * </p>
         * 
         * @param renderTypeDeclarations
         *        Specifies whether the code generation job should render type declaration files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renderTypeDeclarations(Boolean renderTypeDeclarations);

        /**
         * <p>
         * Specifies whether the code generation job should render inline source maps.
         * </p>
         * 
         * @param inlineSourceMap
         *        Specifies whether the code generation job should render inline source maps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inlineSourceMap(Boolean inlineSourceMap);
    }

    static final class BuilderImpl implements Builder {
        private String module;

        private String target;

        private String script;

        private Boolean renderTypeDeclarations;

        private Boolean inlineSourceMap;

        private BuilderImpl() {
        }

        private BuilderImpl(ReactStartCodegenJobData model) {
            module(model.module);
            target(model.target);
            script(model.script);
            renderTypeDeclarations(model.renderTypeDeclarations);
            inlineSourceMap(model.inlineSourceMap);
        }

        public final String getModule() {
            return module;
        }

        public final void setModule(String module) {
            this.module = module;
        }

        @Override
        public final Builder module(String module) {
            this.module = module;
            return this;
        }

        @Override
        public final Builder module(JSModule module) {
            this.module(module == null ? null : module.toString());
            return this;
        }

        public final String getTarget() {
            return target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        @Override
        public final Builder target(JSTarget target) {
            this.target(target == null ? null : target.toString());
            return this;
        }

        public final String getScript() {
            return script;
        }

        public final void setScript(String script) {
            this.script = script;
        }

        @Override
        public final Builder script(String script) {
            this.script = script;
            return this;
        }

        @Override
        public final Builder script(JSScript script) {
            this.script(script == null ? null : script.toString());
            return this;
        }

        public final Boolean getRenderTypeDeclarations() {
            return renderTypeDeclarations;
        }

        public final void setRenderTypeDeclarations(Boolean renderTypeDeclarations) {
            this.renderTypeDeclarations = renderTypeDeclarations;
        }

        @Override
        public final Builder renderTypeDeclarations(Boolean renderTypeDeclarations) {
            this.renderTypeDeclarations = renderTypeDeclarations;
            return this;
        }

        public final Boolean getInlineSourceMap() {
            return inlineSourceMap;
        }

        public final void setInlineSourceMap(Boolean inlineSourceMap) {
            this.inlineSourceMap = inlineSourceMap;
        }

        @Override
        public final Builder inlineSourceMap(Boolean inlineSourceMap) {
            this.inlineSourceMap = inlineSourceMap;
            return this;
        }

        @Override
        public ReactStartCodegenJobData build() {
            return new ReactStartCodegenJobData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
