/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplifybackend.model.AmplifyBackendRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBackendJobRequest
extends AmplifyBackendRequest
implements ToCopyableBuilder<Builder, GetBackendJobRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppId").getter(GetBackendJobRequest.getter(GetBackendJobRequest::appId)).setter(GetBackendJobRequest.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()}).build();
    private static final SdkField<String> BACKEND_ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackendEnvironmentName").getter(GetBackendJobRequest.getter(GetBackendJobRequest::backendEnvironmentName)).setter(GetBackendJobRequest.setter(Builder::backendEnvironmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("backendEnvironmentName").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(GetBackendJobRequest.getter(GetBackendJobRequest::jobId)).setter(GetBackendJobRequest.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, BACKEND_ENVIRONMENT_NAME_FIELD, JOB_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetBackendJobRequest.memberNameToFieldInitializer();
    private final String appId;
    private final String backendEnvironmentName;
    private final String jobId;

    private GetBackendJobRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.backendEnvironmentName = builder.backendEnvironmentName;
        this.jobId = builder.jobId;
    }

    public final String appId() {
        return this.appId;
    }

    public final String backendEnvironmentName() {
        return this.backendEnvironmentName;
    }

    public final String jobId() {
        return this.jobId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.backendEnvironmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBackendJobRequest)) {
            return false;
        }
        GetBackendJobRequest other = (GetBackendJobRequest)((Object)obj);
        return Objects.equals(this.appId(), other.appId()) && Objects.equals(this.backendEnvironmentName(), other.backendEnvironmentName()) && Objects.equals(this.jobId(), other.jobId());
    }

    public final String toString() {
        return ToString.builder((String)"GetBackendJobRequest").add("AppId", (Object)this.appId()).add("BackendEnvironmentName", (Object)this.backendEnvironmentName()).add("JobId", (Object)this.jobId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "BackendEnvironmentName": {
                return Optional.ofNullable(clazz.cast(this.backendEnvironmentName()));
            }
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("appId", APP_ID_FIELD);
        map.put("backendEnvironmentName", BACKEND_ENVIRONMENT_NAME_FIELD);
        map.put("jobId", JOB_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBackendJobRequest, T> g) {
        return obj -> g.apply((GetBackendJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyBackendRequest.BuilderImpl
    implements Builder {
        private String appId;
        private String backendEnvironmentName;
        private String jobId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBackendJobRequest model) {
            super(model);
            this.appId(model.appId);
            this.backendEnvironmentName(model.backendEnvironmentName);
            this.jobId(model.jobId);
        }

        public final String getAppId() {
            return this.appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getBackendEnvironmentName() {
            return this.backendEnvironmentName;
        }

        public final void setBackendEnvironmentName(String backendEnvironmentName) {
            this.backendEnvironmentName = backendEnvironmentName;
        }

        @Override
        public final Builder backendEnvironmentName(String backendEnvironmentName) {
            this.backendEnvironmentName = backendEnvironmentName;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetBackendJobRequest build() {
            return new GetBackendJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AmplifyBackendRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBackendJobRequest> {
        public Builder appId(String var1);

        public Builder backendEnvironmentName(String var1);

        public Builder jobId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

