/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.amplifybackend.AmplifyBackendAsyncClient;
import software.amazon.awssdk.services.amplifybackend.AmplifyBackendAsyncClientBuilder;
import software.amazon.awssdk.services.amplifybackend.AmplifyBackendServiceClientConfiguration;
import software.amazon.awssdk.services.amplifybackend.DefaultAmplifyBackendAsyncClient;
import software.amazon.awssdk.services.amplifybackend.DefaultAmplifyBackendBaseClientBuilder;
import software.amazon.awssdk.services.amplifybackend.endpoints.AmplifyBackendEndpointProvider;

@SdkInternalApi
final class DefaultAmplifyBackendAsyncClientBuilder
extends DefaultAmplifyBackendBaseClientBuilder<AmplifyBackendAsyncClientBuilder, AmplifyBackendAsyncClient>
implements AmplifyBackendAsyncClientBuilder {
    DefaultAmplifyBackendAsyncClientBuilder() {
    }

    @Override
    public DefaultAmplifyBackendAsyncClientBuilder endpointProvider(AmplifyBackendEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AmplifyBackendAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultAmplifyBackendAsyncClientBuilder.validateClientOptions(clientConfiguration);
        AmplifyBackendServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultAmplifyBackendAsyncClient client = new DefaultAmplifyBackendAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private AmplifyBackendServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return AmplifyBackendServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

