/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.amplifybackend.AmplifyBackendClient;
import software.amazon.awssdk.services.amplifybackend.AmplifyBackendClientBuilder;
import software.amazon.awssdk.services.amplifybackend.AmplifyBackendServiceClientConfiguration;
import software.amazon.awssdk.services.amplifybackend.DefaultAmplifyBackendBaseClientBuilder;
import software.amazon.awssdk.services.amplifybackend.DefaultAmplifyBackendClient;
import software.amazon.awssdk.services.amplifybackend.endpoints.AmplifyBackendEndpointProvider;

@SdkInternalApi
final class DefaultAmplifyBackendClientBuilder
extends DefaultAmplifyBackendBaseClientBuilder<AmplifyBackendClientBuilder, AmplifyBackendClient>
implements AmplifyBackendClientBuilder {
    DefaultAmplifyBackendClientBuilder() {
    }

    @Override
    public DefaultAmplifyBackendClientBuilder endpointProvider(AmplifyBackendEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AmplifyBackendClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultAmplifyBackendClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        AmplifyBackendServiceClientConfiguration serviceClientConfiguration = AmplifyBackendServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultAmplifyBackendClient(serviceClientConfiguration, clientConfiguration);
    }
}

