/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MfaTypesElement {
    SMS("SMS"),
    TOTP("TOTP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MfaTypesElement> VALUE_MAP;
    private final String value;

    private MfaTypesElement(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MfaTypesElement fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MfaTypesElement> knownValues() {
        EnumSet<MfaTypesElement> knownValues = EnumSet.allOf(MfaTypesElement.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MfaTypesElement.class, MfaTypesElement::toString);
    }
}

