/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.amplify.model.AmplifyRequest;
import software.amazon.awssdk.services.amplify.model.SubDomainSetting;
import software.amazon.awssdk.services.amplify.model.SubDomainSettingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDomainAssociationRequest
extends AmplifyRequest
implements ToCopyableBuilder<Builder, CreateDomainAssociationRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDomainAssociationRequest.getter(CreateDomainAssociationRequest::appId)).setter(CreateDomainAssociationRequest.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateDomainAssociationRequest.getter(CreateDomainAssociationRequest::domainName)).setter(CreateDomainAssociationRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<Boolean> ENABLE_AUTO_SUB_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateDomainAssociationRequest.getter(CreateDomainAssociationRequest::enableAutoSubDomain)).setter(CreateDomainAssociationRequest.setter(Builder::enableAutoSubDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableAutoSubDomain").build()}).build();
    private static final SdkField<List<SubDomainSetting>> SUB_DOMAIN_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateDomainAssociationRequest.getter(CreateDomainAssociationRequest::subDomainSettings)).setter(CreateDomainAssociationRequest.setter(Builder::subDomainSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subDomainSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SubDomainSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, DOMAIN_NAME_FIELD, ENABLE_AUTO_SUB_DOMAIN_FIELD, SUB_DOMAIN_SETTINGS_FIELD));
    private final String appId;
    private final String domainName;
    private final Boolean enableAutoSubDomain;
    private final List<SubDomainSetting> subDomainSettings;

    private CreateDomainAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.domainName = builder.domainName;
        this.enableAutoSubDomain = builder.enableAutoSubDomain;
        this.subDomainSettings = builder.subDomainSettings;
    }

    public String appId() {
        return this.appId;
    }

    public String domainName() {
        return this.domainName;
    }

    public Boolean enableAutoSubDomain() {
        return this.enableAutoSubDomain;
    }

    public List<SubDomainSetting> subDomainSettings() {
        return this.subDomainSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableAutoSubDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.subDomainSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDomainAssociationRequest)) {
            return false;
        }
        CreateDomainAssociationRequest other = (CreateDomainAssociationRequest)((Object)obj);
        return Objects.equals(this.appId(), other.appId()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.enableAutoSubDomain(), other.enableAutoSubDomain()) && Objects.equals(this.subDomainSettings(), other.subDomainSettings());
    }

    public String toString() {
        return ToString.builder((String)"CreateDomainAssociationRequest").add("AppId", (Object)this.appId()).add("DomainName", (Object)this.domainName()).add("EnableAutoSubDomain", (Object)this.enableAutoSubDomain()).add("SubDomainSettings", this.subDomainSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "enableAutoSubDomain": {
                return Optional.ofNullable(clazz.cast(this.enableAutoSubDomain()));
            }
            case "subDomainSettings": {
                return Optional.ofNullable(clazz.cast(this.subDomainSettings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDomainAssociationRequest, T> g) {
        return obj -> g.apply((CreateDomainAssociationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyRequest.BuilderImpl
    implements Builder {
        private String appId;
        private String domainName;
        private Boolean enableAutoSubDomain;
        private List<SubDomainSetting> subDomainSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDomainAssociationRequest model) {
            super(model);
            this.appId(model.appId);
            this.domainName(model.domainName);
            this.enableAutoSubDomain(model.enableAutoSubDomain);
            this.subDomainSettings(model.subDomainSettings);
        }

        public final String getAppId() {
            return this.appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Boolean getEnableAutoSubDomain() {
            return this.enableAutoSubDomain;
        }

        @Override
        public final Builder enableAutoSubDomain(Boolean enableAutoSubDomain) {
            this.enableAutoSubDomain = enableAutoSubDomain;
            return this;
        }

        public final void setEnableAutoSubDomain(Boolean enableAutoSubDomain) {
            this.enableAutoSubDomain = enableAutoSubDomain;
        }

        public final Collection<SubDomainSetting.Builder> getSubDomainSettings() {
            return this.subDomainSettings != null ? (Collection)this.subDomainSettings.stream().map(SubDomainSetting::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subDomainSettings(Collection<SubDomainSetting> subDomainSettings) {
            this.subDomainSettings = SubDomainSettingsCopier.copy(subDomainSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subDomainSettings(SubDomainSetting ... subDomainSettings) {
            this.subDomainSettings(Arrays.asList(subDomainSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subDomainSettings(Consumer<SubDomainSetting.Builder> ... subDomainSettings) {
            this.subDomainSettings(Stream.of(subDomainSettings).map(c -> (SubDomainSetting)((SubDomainSetting.Builder)SubDomainSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSubDomainSettings(Collection<SubDomainSetting.BuilderImpl> subDomainSettings) {
            this.subDomainSettings = SubDomainSettingsCopier.copyFromBuilder(subDomainSettings);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDomainAssociationRequest build() {
            return new CreateDomainAssociationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AmplifyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDomainAssociationRequest> {
        public Builder appId(String var1);

        public Builder domainName(String var1);

        public Builder enableAutoSubDomain(Boolean var1);

        public Builder subDomainSettings(Collection<SubDomainSetting> var1);

        public Builder subDomainSettings(SubDomainSetting ... var1);

        public Builder subDomainSettings(Consumer<SubDomainSetting.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

