/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplify.model.AmplifyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBranchRequest
extends AmplifyRequest
implements ToCopyableBuilder<Builder, GetBranchRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetBranchRequest.getter(GetBranchRequest::appId)).setter(GetBranchRequest.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()}).build();
    private static final SdkField<String> BRANCH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetBranchRequest.getter(GetBranchRequest::branchName)).setter(GetBranchRequest.setter(Builder::branchName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("branchName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, BRANCH_NAME_FIELD));
    private final String appId;
    private final String branchName;

    private GetBranchRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.branchName = builder.branchName;
    }

    public String appId() {
        return this.appId;
    }

    public String branchName() {
        return this.branchName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.branchName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBranchRequest)) {
            return false;
        }
        GetBranchRequest other = (GetBranchRequest)((Object)obj);
        return Objects.equals(this.appId(), other.appId()) && Objects.equals(this.branchName(), other.branchName());
    }

    public String toString() {
        return ToString.builder((String)"GetBranchRequest").add("AppId", (Object)this.appId()).add("BranchName", (Object)this.branchName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "branchName": {
                return Optional.ofNullable(clazz.cast(this.branchName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBranchRequest, T> g) {
        return obj -> g.apply((GetBranchRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyRequest.BuilderImpl
    implements Builder {
        private String appId;
        private String branchName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBranchRequest model) {
            super(model);
            this.appId(model.appId);
            this.branchName(model.branchName);
        }

        public final String getAppId() {
            return this.appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final String getBranchName() {
            return this.branchName;
        }

        @Override
        public final Builder branchName(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public final void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetBranchRequest build() {
            return new GetBranchRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AmplifyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBranchRequest> {
        public Builder appId(String var1);

        public Builder branchName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

