/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.amplify.AmplifyClient;
import software.amazon.awssdk.services.amplify.internal.UserAgentUtils;
import software.amazon.awssdk.services.amplify.model.App;
import software.amazon.awssdk.services.amplify.model.ListAppsRequest;
import software.amazon.awssdk.services.amplify.model.ListAppsResponse;

public class ListAppsIterable
implements SdkIterable<ListAppsResponse> {
    private final AmplifyClient client;
    private final ListAppsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAppsIterable(AmplifyClient client, ListAppsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAppsResponseFetcher();
    }

    public Iterator<ListAppsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<App> apps() {
        Function<ListAppsResponse, Iterator> getIterator = response -> {
            if (response != null && response.apps() != null) {
                return response.apps().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAppsResponseFetcher
    implements SyncPageFetcher<ListAppsResponse> {
        private ListAppsResponseFetcher() {
        }

        public boolean hasNextPage(ListAppsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAppsResponse nextPage(ListAppsResponse previousPage) {
            if (previousPage == null) {
                return ListAppsIterable.this.client.listApps(ListAppsIterable.this.firstRequest);
            }
            return ListAppsIterable.this.client.listApps((ListAppsRequest)((Object)ListAppsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

