/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UpdateStatus {
    REQUESTING_CERTIFICATE("REQUESTING_CERTIFICATE"),
    PENDING_VERIFICATION("PENDING_VERIFICATION"),
    IMPORTING_CUSTOM_CERTIFICATE("IMPORTING_CUSTOM_CERTIFICATE"),
    PENDING_DEPLOYMENT("PENDING_DEPLOYMENT"),
    AWAITING_APP_CNAME("AWAITING_APP_CNAME"),
    UPDATE_COMPLETE("UPDATE_COMPLETE"),
    UPDATE_FAILED("UPDATE_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UpdateStatus> VALUE_MAP;
    private final String value;

    private UpdateStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UpdateStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UpdateStatus> knownValues() {
        EnumSet<UpdateStatus> knownValues = EnumSet.allOf(UpdateStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UpdateStatus.class, UpdateStatus::toString);
    }
}

