/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.amplify.AmplifyAsyncClient;
import software.amazon.awssdk.services.amplify.internal.UserAgentUtils;
import software.amazon.awssdk.services.amplify.model.DomainAssociation;
import software.amazon.awssdk.services.amplify.model.ListDomainAssociationsRequest;
import software.amazon.awssdk.services.amplify.model.ListDomainAssociationsResponse;

public class ListDomainAssociationsPublisher
implements SdkPublisher<ListDomainAssociationsResponse> {
    private final AmplifyAsyncClient client;
    private final ListDomainAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDomainAssociationsPublisher(AmplifyAsyncClient client, ListDomainAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDomainAssociationsPublisher(AmplifyAsyncClient client, ListDomainAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDomainAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDomainAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DomainAssociation> domainAssociations() {
        Function<ListDomainAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.domainAssociations() != null) {
                return response.domainAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDomainAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDomainAssociationsResponseFetcher
    implements AsyncPageFetcher<ListDomainAssociationsResponse> {
        private ListDomainAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListDomainAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDomainAssociationsResponse> nextPage(ListDomainAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListDomainAssociationsPublisher.this.client.listDomainAssociations(ListDomainAssociationsPublisher.this.firstRequest);
            }
            return ListDomainAssociationsPublisher.this.client.listDomainAssociations((ListDomainAssociationsRequest)((Object)ListDomainAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

