/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Artifact
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Artifact> {
    private static final SdkField<String> ARTIFACT_FILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Artifact.getter(Artifact::artifactFileName)).setter(Artifact.setter(Builder::artifactFileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactFileName").build()}).build();
    private static final SdkField<String> ARTIFACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Artifact.getter(Artifact::artifactId)).setter(Artifact.setter(Builder::artifactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARTIFACT_FILE_NAME_FIELD, ARTIFACT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String artifactFileName;
    private final String artifactId;

    private Artifact(BuilderImpl builder) {
        this.artifactFileName = builder.artifactFileName;
        this.artifactId = builder.artifactId;
    }

    public String artifactFileName() {
        return this.artifactFileName;
    }

    public String artifactId() {
        return this.artifactId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactFileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Artifact)) {
            return false;
        }
        Artifact other = (Artifact)obj;
        return Objects.equals(this.artifactFileName(), other.artifactFileName()) && Objects.equals(this.artifactId(), other.artifactId());
    }

    public String toString() {
        return ToString.builder((String)"Artifact").add("ArtifactFileName", (Object)this.artifactFileName()).add("ArtifactId", (Object)this.artifactId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "artifactFileName": {
                return Optional.ofNullable(clazz.cast(this.artifactFileName()));
            }
            case "artifactId": {
                return Optional.ofNullable(clazz.cast(this.artifactId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Artifact, T> g) {
        return obj -> g.apply((Artifact)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String artifactFileName;
        private String artifactId;

        private BuilderImpl() {
        }

        private BuilderImpl(Artifact model) {
            this.artifactFileName(model.artifactFileName);
            this.artifactId(model.artifactId);
        }

        public final String getArtifactFileName() {
            return this.artifactFileName;
        }

        @Override
        public final Builder artifactFileName(String artifactFileName) {
            this.artifactFileName = artifactFileName;
            return this;
        }

        public final void setArtifactFileName(String artifactFileName) {
            this.artifactFileName = artifactFileName;
        }

        public final String getArtifactId() {
            return this.artifactId;
        }

        @Override
        public final Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public final void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public Artifact build() {
            return new Artifact(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Artifact> {
        public Builder artifactFileName(String var1);

        public Builder artifactId(String var1);
    }
}

