/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.acmpca.AcmPcaClient;
import software.amazon.awssdk.services.acmpca.model.CertificateAuthority;
import software.amazon.awssdk.services.acmpca.model.ListCertificateAuthoritiesRequest;
import software.amazon.awssdk.services.acmpca.model.ListCertificateAuthoritiesResponse;

public class ListCertificateAuthoritiesIterable
implements SdkIterable<ListCertificateAuthoritiesResponse> {
    private final AcmPcaClient client;
    private final ListCertificateAuthoritiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCertificateAuthoritiesIterable(AcmPcaClient client, ListCertificateAuthoritiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCertificateAuthoritiesResponseFetcher();
    }

    public Iterator<ListCertificateAuthoritiesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CertificateAuthority> certificateAuthorities() {
        Function<ListCertificateAuthoritiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.certificateAuthorities() != null) {
                return response.certificateAuthorities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final ListCertificateAuthoritiesIterable resume(ListCertificateAuthoritiesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListCertificateAuthoritiesIterable(this.client, (ListCertificateAuthoritiesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListCertificateAuthoritiesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListCertificateAuthoritiesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListCertificateAuthoritiesResponseFetcher
    implements SyncPageFetcher<ListCertificateAuthoritiesResponse> {
        private ListCertificateAuthoritiesResponseFetcher() {
        }

        public boolean hasNextPage(ListCertificateAuthoritiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCertificateAuthoritiesResponse nextPage(ListCertificateAuthoritiesResponse previousPage) {
            if (previousPage == null) {
                return ListCertificateAuthoritiesIterable.this.client.listCertificateAuthorities(ListCertificateAuthoritiesIterable.this.firstRequest);
            }
            return ListCertificateAuthoritiesIterable.this.client.listCertificateAuthorities((ListCertificateAuthoritiesRequest)((Object)ListCertificateAuthoritiesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

