/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.acmpca.model.AcmPcaRequest;
import software.amazon.awssdk.services.acmpca.model.CertificateAuthorityConfiguration;
import software.amazon.awssdk.services.acmpca.model.CertificateAuthorityType;
import software.amazon.awssdk.services.acmpca.model.RevocationConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCertificateAuthorityRequest
extends AcmPcaRequest
implements ToCopyableBuilder<Builder, CreateCertificateAuthorityRequest> {
    private static final SdkField<CertificateAuthorityConfiguration> CERTIFICATE_AUTHORITY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateCertificateAuthorityRequest.getter(CreateCertificateAuthorityRequest::certificateAuthorityConfiguration)).setter(CreateCertificateAuthorityRequest.setter(Builder::certificateAuthorityConfiguration)).constructor(CertificateAuthorityConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityConfiguration").build()}).build();
    private static final SdkField<RevocationConfiguration> REVOCATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateCertificateAuthorityRequest.getter(CreateCertificateAuthorityRequest::revocationConfiguration)).setter(CreateCertificateAuthorityRequest.setter(Builder::revocationConfiguration)).constructor(RevocationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevocationConfiguration").build()}).build();
    private static final SdkField<String> CERTIFICATE_AUTHORITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCertificateAuthorityRequest.getter(CreateCertificateAuthorityRequest::certificateAuthorityTypeAsString)).setter(CreateCertificateAuthorityRequest.setter(Builder::certificateAuthorityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityType").build()}).build();
    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateCertificateAuthorityRequest.getter(CreateCertificateAuthorityRequest::idempotencyToken)).setter(CreateCertificateAuthorityRequest.setter(Builder::idempotencyToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_AUTHORITY_CONFIGURATION_FIELD, REVOCATION_CONFIGURATION_FIELD, CERTIFICATE_AUTHORITY_TYPE_FIELD, IDEMPOTENCY_TOKEN_FIELD));
    private final CertificateAuthorityConfiguration certificateAuthorityConfiguration;
    private final RevocationConfiguration revocationConfiguration;
    private final String certificateAuthorityType;
    private final String idempotencyToken;

    private CreateCertificateAuthorityRequest(BuilderImpl builder) {
        super(builder);
        this.certificateAuthorityConfiguration = builder.certificateAuthorityConfiguration;
        this.revocationConfiguration = builder.revocationConfiguration;
        this.certificateAuthorityType = builder.certificateAuthorityType;
        this.idempotencyToken = builder.idempotencyToken;
    }

    public CertificateAuthorityConfiguration certificateAuthorityConfiguration() {
        return this.certificateAuthorityConfiguration;
    }

    public RevocationConfiguration revocationConfiguration() {
        return this.revocationConfiguration;
    }

    public CertificateAuthorityType certificateAuthorityType() {
        return CertificateAuthorityType.fromValue(this.certificateAuthorityType);
    }

    public String certificateAuthorityTypeAsString() {
        return this.certificateAuthorityType;
    }

    public String idempotencyToken() {
        return this.idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateAuthorityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.revocationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateAuthorityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCertificateAuthorityRequest)) {
            return false;
        }
        CreateCertificateAuthorityRequest other = (CreateCertificateAuthorityRequest)((Object)obj);
        return Objects.equals(this.certificateAuthorityConfiguration(), other.certificateAuthorityConfiguration()) && Objects.equals(this.revocationConfiguration(), other.revocationConfiguration()) && Objects.equals(this.certificateAuthorityTypeAsString(), other.certificateAuthorityTypeAsString()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken());
    }

    public String toString() {
        return ToString.builder((String)"CreateCertificateAuthorityRequest").add("CertificateAuthorityConfiguration", (Object)this.certificateAuthorityConfiguration()).add("RevocationConfiguration", (Object)this.revocationConfiguration()).add("CertificateAuthorityType", (Object)this.certificateAuthorityTypeAsString()).add("IdempotencyToken", (Object)this.idempotencyToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateAuthorityConfiguration": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthorityConfiguration()));
            }
            case "RevocationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.revocationConfiguration()));
            }
            case "CertificateAuthorityType": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthorityTypeAsString()));
            }
            case "IdempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCertificateAuthorityRequest, T> g) {
        return obj -> g.apply((CreateCertificateAuthorityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AcmPcaRequest.BuilderImpl
    implements Builder {
        private CertificateAuthorityConfiguration certificateAuthorityConfiguration;
        private RevocationConfiguration revocationConfiguration;
        private String certificateAuthorityType;
        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCertificateAuthorityRequest model) {
            super(model);
            this.certificateAuthorityConfiguration(model.certificateAuthorityConfiguration);
            this.revocationConfiguration(model.revocationConfiguration);
            this.certificateAuthorityType(model.certificateAuthorityType);
            this.idempotencyToken(model.idempotencyToken);
        }

        public final CertificateAuthorityConfiguration.Builder getCertificateAuthorityConfiguration() {
            return this.certificateAuthorityConfiguration != null ? this.certificateAuthorityConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder certificateAuthorityConfiguration(CertificateAuthorityConfiguration certificateAuthorityConfiguration) {
            this.certificateAuthorityConfiguration = certificateAuthorityConfiguration;
            return this;
        }

        public final void setCertificateAuthorityConfiguration(CertificateAuthorityConfiguration.BuilderImpl certificateAuthorityConfiguration) {
            this.certificateAuthorityConfiguration = certificateAuthorityConfiguration != null ? certificateAuthorityConfiguration.build() : null;
        }

        public final RevocationConfiguration.Builder getRevocationConfiguration() {
            return this.revocationConfiguration != null ? this.revocationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder revocationConfiguration(RevocationConfiguration revocationConfiguration) {
            this.revocationConfiguration = revocationConfiguration;
            return this;
        }

        public final void setRevocationConfiguration(RevocationConfiguration.BuilderImpl revocationConfiguration) {
            this.revocationConfiguration = revocationConfiguration != null ? revocationConfiguration.build() : null;
        }

        public final String getCertificateAuthorityTypeAsString() {
            return this.certificateAuthorityType;
        }

        @Override
        public final Builder certificateAuthorityType(String certificateAuthorityType) {
            this.certificateAuthorityType = certificateAuthorityType;
            return this;
        }

        @Override
        public final Builder certificateAuthorityType(CertificateAuthorityType certificateAuthorityType) {
            this.certificateAuthorityType(certificateAuthorityType.toString());
            return this;
        }

        public final void setCertificateAuthorityType(String certificateAuthorityType) {
            this.certificateAuthorityType = certificateAuthorityType;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCertificateAuthorityRequest build() {
            return new CreateCertificateAuthorityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AcmPcaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCertificateAuthorityRequest> {
        public Builder certificateAuthorityConfiguration(CertificateAuthorityConfiguration var1);

        default public Builder certificateAuthorityConfiguration(Consumer<CertificateAuthorityConfiguration.Builder> certificateAuthorityConfiguration) {
            return this.certificateAuthorityConfiguration((CertificateAuthorityConfiguration)((CertificateAuthorityConfiguration.Builder)CertificateAuthorityConfiguration.builder().applyMutation(certificateAuthorityConfiguration)).build());
        }

        public Builder revocationConfiguration(RevocationConfiguration var1);

        default public Builder revocationConfiguration(Consumer<RevocationConfiguration.Builder> revocationConfiguration) {
            return this.revocationConfiguration((RevocationConfiguration)((RevocationConfiguration.Builder)RevocationConfiguration.builder().applyMutation(revocationConfiguration)).build());
        }

        public Builder certificateAuthorityType(String var1);

        public Builder certificateAuthorityType(CertificateAuthorityType var1);

        public Builder idempotencyToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

