/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acmpca.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.acmpca.model.AcmPcaRequest;
import software.amazon.awssdk.services.acmpca.model.SigningAlgorithm;
import software.amazon.awssdk.services.acmpca.model.Validity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IssueCertificateRequest
extends AcmPcaRequest
implements ToCopyableBuilder<Builder, IssueCertificateRequest> {
    private static final SdkField<String> CERTIFICATE_AUTHORITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(IssueCertificateRequest.getter(IssueCertificateRequest::certificateAuthorityArn)).setter(IssueCertificateRequest.setter(Builder::certificateAuthorityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityArn").build()}).build();
    private static final SdkField<SdkBytes> CSR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).getter(IssueCertificateRequest.getter(IssueCertificateRequest::csr)).setter(IssueCertificateRequest.setter(Builder::csr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Csr").build()}).build();
    private static final SdkField<String> SIGNING_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(IssueCertificateRequest.getter(IssueCertificateRequest::signingAlgorithmAsString)).setter(IssueCertificateRequest.setter(Builder::signingAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningAlgorithm").build()}).build();
    private static final SdkField<Validity> VALIDITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(IssueCertificateRequest.getter(IssueCertificateRequest::validity)).setter(IssueCertificateRequest.setter(Builder::validity)).constructor(Validity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Validity").build()}).build();
    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(IssueCertificateRequest.getter(IssueCertificateRequest::idempotencyToken)).setter(IssueCertificateRequest.setter(Builder::idempotencyToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_AUTHORITY_ARN_FIELD, CSR_FIELD, SIGNING_ALGORITHM_FIELD, VALIDITY_FIELD, IDEMPOTENCY_TOKEN_FIELD));
    private final String certificateAuthorityArn;
    private final SdkBytes csr;
    private final String signingAlgorithm;
    private final Validity validity;
    private final String idempotencyToken;

    private IssueCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.certificateAuthorityArn = builder.certificateAuthorityArn;
        this.csr = builder.csr;
        this.signingAlgorithm = builder.signingAlgorithm;
        this.validity = builder.validity;
        this.idempotencyToken = builder.idempotencyToken;
    }

    public String certificateAuthorityArn() {
        return this.certificateAuthorityArn;
    }

    public SdkBytes csr() {
        return this.csr;
    }

    public SigningAlgorithm signingAlgorithm() {
        return SigningAlgorithm.fromValue(this.signingAlgorithm);
    }

    public String signingAlgorithmAsString() {
        return this.signingAlgorithm;
    }

    public Validity validity() {
        return this.validity;
    }

    public String idempotencyToken() {
        return this.idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateAuthorityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.csr());
        hashCode = 31 * hashCode + Objects.hashCode(this.signingAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.validity());
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IssueCertificateRequest)) {
            return false;
        }
        IssueCertificateRequest other = (IssueCertificateRequest)((Object)obj);
        return Objects.equals(this.certificateAuthorityArn(), other.certificateAuthorityArn()) && Objects.equals(this.csr(), other.csr()) && Objects.equals(this.signingAlgorithmAsString(), other.signingAlgorithmAsString()) && Objects.equals(this.validity(), other.validity()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken());
    }

    public String toString() {
        return ToString.builder((String)"IssueCertificateRequest").add("CertificateAuthorityArn", (Object)this.certificateAuthorityArn()).add("Csr", (Object)this.csr()).add("SigningAlgorithm", (Object)this.signingAlgorithmAsString()).add("Validity", (Object)this.validity()).add("IdempotencyToken", (Object)this.idempotencyToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateAuthorityArn": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthorityArn()));
            }
            case "Csr": {
                return Optional.ofNullable(clazz.cast(this.csr()));
            }
            case "SigningAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.signingAlgorithmAsString()));
            }
            case "Validity": {
                return Optional.ofNullable(clazz.cast(this.validity()));
            }
            case "IdempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IssueCertificateRequest, T> g) {
        return obj -> g.apply((IssueCertificateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AcmPcaRequest.BuilderImpl
    implements Builder {
        private String certificateAuthorityArn;
        private SdkBytes csr;
        private String signingAlgorithm;
        private Validity validity;
        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(IssueCertificateRequest model) {
            super(model);
            this.certificateAuthorityArn(model.certificateAuthorityArn);
            this.csr(model.csr);
            this.signingAlgorithm(model.signingAlgorithm);
            this.validity(model.validity);
            this.idempotencyToken(model.idempotencyToken);
        }

        public final String getCertificateAuthorityArn() {
            return this.certificateAuthorityArn;
        }

        @Override
        public final Builder certificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
            return this;
        }

        public final void setCertificateAuthorityArn(String certificateAuthorityArn) {
            this.certificateAuthorityArn = certificateAuthorityArn;
        }

        public final ByteBuffer getCsr() {
            return this.csr == null ? null : this.csr.asByteBuffer();
        }

        @Override
        public final Builder csr(SdkBytes csr) {
            this.csr = StandardMemberCopier.copy((SdkBytes)csr);
            return this;
        }

        public final void setCsr(ByteBuffer csr) {
            this.csr(csr == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)csr));
        }

        public final String getSigningAlgorithm() {
            return this.signingAlgorithm;
        }

        @Override
        public final Builder signingAlgorithm(String signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
            return this;
        }

        @Override
        public final Builder signingAlgorithm(SigningAlgorithm signingAlgorithm) {
            this.signingAlgorithm(signingAlgorithm.toString());
            return this;
        }

        public final void setSigningAlgorithm(String signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
        }

        public final Validity.Builder getValidity() {
            return this.validity != null ? this.validity.toBuilder() : null;
        }

        @Override
        public final Builder validity(Validity validity) {
            this.validity = validity;
            return this;
        }

        public final void setValidity(Validity.BuilderImpl validity) {
            this.validity = validity != null ? validity.build() : null;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public IssueCertificateRequest build() {
            return new IssueCertificateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AcmPcaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, IssueCertificateRequest> {
        public Builder certificateAuthorityArn(String var1);

        public Builder csr(SdkBytes var1);

        public Builder signingAlgorithm(String var1);

        public Builder signingAlgorithm(SigningAlgorithm var1);

        public Builder validity(Validity var1);

        default public Builder validity(Consumer<Validity.Builder> validity) {
            return this.validity((Validity)((Validity.Builder)Validity.builder().applyMutation(validity)).build());
        }

        public Builder idempotencyToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

