/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InternalAccessType {
    INTRA_ACCOUNT("INTRA_ACCOUNT"),
    INTRA_ORG("INTRA_ORG"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InternalAccessType> VALUE_MAP;
    private final String value;

    private InternalAccessType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InternalAccessType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InternalAccessType> knownValues() {
        EnumSet<InternalAccessType> knownValues = EnumSet.allOf(InternalAccessType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InternalAccessType.class, InternalAccessType::toString);
    }
}

