/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Retrieves an archive rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetArchiveRuleRequest extends AccessAnalyzerRequest implements
        ToCopyableBuilder<GetArchiveRuleRequest.Builder, GetArchiveRuleRequest> {
    private static final SdkField<String> ANALYZER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("analyzerName").getter(getter(GetArchiveRuleRequest::analyzerName)).setter(setter(Builder::analyzerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("analyzerName").build()).build();

    private static final SdkField<String> RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ruleName").getter(getter(GetArchiveRuleRequest::ruleName)).setter(setter(Builder::ruleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ruleName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYZER_NAME_FIELD,
            RULE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String analyzerName;

    private final String ruleName;

    private GetArchiveRuleRequest(BuilderImpl builder) {
        super(builder);
        this.analyzerName = builder.analyzerName;
        this.ruleName = builder.ruleName;
    }

    /**
     * <p>
     * The name of the analyzer to retrieve rules from.
     * </p>
     * 
     * @return The name of the analyzer to retrieve rules from.
     */
    public final String analyzerName() {
        return analyzerName;
    }

    /**
     * <p>
     * The name of the rule to retrieve.
     * </p>
     * 
     * @return The name of the rule to retrieve.
     */
    public final String ruleName() {
        return ruleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(analyzerName());
        hashCode = 31 * hashCode + Objects.hashCode(ruleName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetArchiveRuleRequest)) {
            return false;
        }
        GetArchiveRuleRequest other = (GetArchiveRuleRequest) obj;
        return Objects.equals(analyzerName(), other.analyzerName()) && Objects.equals(ruleName(), other.ruleName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetArchiveRuleRequest").add("AnalyzerName", analyzerName()).add("RuleName", ruleName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "analyzerName":
            return Optional.ofNullable(clazz.cast(analyzerName()));
        case "ruleName":
            return Optional.ofNullable(clazz.cast(ruleName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("analyzerName", ANALYZER_NAME_FIELD);
        map.put("ruleName", RULE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetArchiveRuleRequest, T> g) {
        return obj -> g.apply((GetArchiveRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AccessAnalyzerRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetArchiveRuleRequest> {
        /**
         * <p>
         * The name of the analyzer to retrieve rules from.
         * </p>
         * 
         * @param analyzerName
         *        The name of the analyzer to retrieve rules from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyzerName(String analyzerName);

        /**
         * <p>
         * The name of the rule to retrieve.
         * </p>
         * 
         * @param ruleName
         *        The name of the rule to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AccessAnalyzerRequest.BuilderImpl implements Builder {
        private String analyzerName;

        private String ruleName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetArchiveRuleRequest model) {
            super(model);
            analyzerName(model.analyzerName);
            ruleName(model.ruleName);
        }

        public final String getAnalyzerName() {
            return analyzerName;
        }

        public final void setAnalyzerName(String analyzerName) {
            this.analyzerName = analyzerName;
        }

        @Override
        public final Builder analyzerName(String analyzerName) {
            this.analyzerName = analyzerName;
            return this;
        }

        public final String getRuleName() {
            return ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetArchiveRuleRequest build() {
            return new GetArchiveRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
