/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides aggregate statistics about the findings for the specified external access analyzer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExternalAccessFindingsStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<ExternalAccessFindingsStatistics.Builder, ExternalAccessFindingsStatistics> {
    private static final SdkField<Map<String, ResourceTypeDetails>> RESOURCE_TYPE_STATISTICS_FIELD = SdkField
            .<Map<String, ResourceTypeDetails>> builder(MarshallingType.MAP)
            .memberName("resourceTypeStatistics")
            .getter(getter(ExternalAccessFindingsStatistics::resourceTypeStatisticsAsStrings))
            .setter(setter(Builder::resourceTypeStatisticsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceTypeStatistics").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ResourceTypeDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceTypeDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> TOTAL_ACTIVE_FINDINGS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalActiveFindings").getter(getter(ExternalAccessFindingsStatistics::totalActiveFindings))
            .setter(setter(Builder::totalActiveFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalActiveFindings").build())
            .build();

    private static final SdkField<Integer> TOTAL_ARCHIVED_FINDINGS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalArchivedFindings").getter(getter(ExternalAccessFindingsStatistics::totalArchivedFindings))
            .setter(setter(Builder::totalArchivedFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalArchivedFindings").build())
            .build();

    private static final SdkField<Integer> TOTAL_RESOLVED_FINDINGS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalResolvedFindings").getter(getter(ExternalAccessFindingsStatistics::totalResolvedFindings))
            .setter(setter(Builder::totalResolvedFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalResolvedFindings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESOURCE_TYPE_STATISTICS_FIELD, TOTAL_ACTIVE_FINDINGS_FIELD, TOTAL_ARCHIVED_FINDINGS_FIELD,
            TOTAL_RESOLVED_FINDINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, ResourceTypeDetails> resourceTypeStatistics;

    private final Integer totalActiveFindings;

    private final Integer totalArchivedFindings;

    private final Integer totalResolvedFindings;

    private ExternalAccessFindingsStatistics(BuilderImpl builder) {
        this.resourceTypeStatistics = builder.resourceTypeStatistics;
        this.totalActiveFindings = builder.totalActiveFindings;
        this.totalArchivedFindings = builder.totalArchivedFindings;
        this.totalResolvedFindings = builder.totalResolvedFindings;
    }

    /**
     * <p>
     * The total number of active cross-account and public findings for each resource type of the specified external
     * access analyzer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypeStatistics} method.
     * </p>
     * 
     * @return The total number of active cross-account and public findings for each resource type of the specified
     *         external access analyzer.
     */
    public final Map<ResourceType, ResourceTypeDetails> resourceTypeStatistics() {
        return ResourceTypeStatisticsMapCopier.copyStringToEnum(resourceTypeStatistics);
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTypeStatistics property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasResourceTypeStatistics() {
        return resourceTypeStatistics != null && !(resourceTypeStatistics instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The total number of active cross-account and public findings for each resource type of the specified external
     * access analyzer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypeStatistics} method.
     * </p>
     * 
     * @return The total number of active cross-account and public findings for each resource type of the specified
     *         external access analyzer.
     */
    public final Map<String, ResourceTypeDetails> resourceTypeStatisticsAsStrings() {
        return resourceTypeStatistics;
    }

    /**
     * <p>
     * The number of active findings for the specified external access analyzer.
     * </p>
     * 
     * @return The number of active findings for the specified external access analyzer.
     */
    public final Integer totalActiveFindings() {
        return totalActiveFindings;
    }

    /**
     * <p>
     * The number of archived findings for the specified external access analyzer.
     * </p>
     * 
     * @return The number of archived findings for the specified external access analyzer.
     */
    public final Integer totalArchivedFindings() {
        return totalArchivedFindings;
    }

    /**
     * <p>
     * The number of resolved findings for the specified external access analyzer.
     * </p>
     * 
     * @return The number of resolved findings for the specified external access analyzer.
     */
    public final Integer totalResolvedFindings() {
        return totalResolvedFindings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTypeStatistics() ? resourceTypeStatisticsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(totalActiveFindings());
        hashCode = 31 * hashCode + Objects.hashCode(totalArchivedFindings());
        hashCode = 31 * hashCode + Objects.hashCode(totalResolvedFindings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalAccessFindingsStatistics)) {
            return false;
        }
        ExternalAccessFindingsStatistics other = (ExternalAccessFindingsStatistics) obj;
        return hasResourceTypeStatistics() == other.hasResourceTypeStatistics()
                && Objects.equals(resourceTypeStatisticsAsStrings(), other.resourceTypeStatisticsAsStrings())
                && Objects.equals(totalActiveFindings(), other.totalActiveFindings())
                && Objects.equals(totalArchivedFindings(), other.totalArchivedFindings())
                && Objects.equals(totalResolvedFindings(), other.totalResolvedFindings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExternalAccessFindingsStatistics")
                .add("ResourceTypeStatistics", hasResourceTypeStatistics() ? resourceTypeStatisticsAsStrings() : null)
                .add("TotalActiveFindings", totalActiveFindings()).add("TotalArchivedFindings", totalArchivedFindings())
                .add("TotalResolvedFindings", totalResolvedFindings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceTypeStatistics":
            return Optional.ofNullable(clazz.cast(resourceTypeStatisticsAsStrings()));
        case "totalActiveFindings":
            return Optional.ofNullable(clazz.cast(totalActiveFindings()));
        case "totalArchivedFindings":
            return Optional.ofNullable(clazz.cast(totalArchivedFindings()));
        case "totalResolvedFindings":
            return Optional.ofNullable(clazz.cast(totalResolvedFindings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resourceTypeStatistics", RESOURCE_TYPE_STATISTICS_FIELD);
        map.put("totalActiveFindings", TOTAL_ACTIVE_FINDINGS_FIELD);
        map.put("totalArchivedFindings", TOTAL_ARCHIVED_FINDINGS_FIELD);
        map.put("totalResolvedFindings", TOTAL_RESOLVED_FINDINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExternalAccessFindingsStatistics, T> g) {
        return obj -> g.apply((ExternalAccessFindingsStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExternalAccessFindingsStatistics> {
        /**
         * <p>
         * The total number of active cross-account and public findings for each resource type of the specified external
         * access analyzer.
         * </p>
         * 
         * @param resourceTypeStatistics
         *        The total number of active cross-account and public findings for each resource type of the specified
         *        external access analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypeStatisticsWithStrings(Map<String, ResourceTypeDetails> resourceTypeStatistics);

        /**
         * <p>
         * The total number of active cross-account and public findings for each resource type of the specified external
         * access analyzer.
         * </p>
         * 
         * @param resourceTypeStatistics
         *        The total number of active cross-account and public findings for each resource type of the specified
         *        external access analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypeStatistics(Map<ResourceType, ResourceTypeDetails> resourceTypeStatistics);

        /**
         * <p>
         * The number of active findings for the specified external access analyzer.
         * </p>
         * 
         * @param totalActiveFindings
         *        The number of active findings for the specified external access analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalActiveFindings(Integer totalActiveFindings);

        /**
         * <p>
         * The number of archived findings for the specified external access analyzer.
         * </p>
         * 
         * @param totalArchivedFindings
         *        The number of archived findings for the specified external access analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalArchivedFindings(Integer totalArchivedFindings);

        /**
         * <p>
         * The number of resolved findings for the specified external access analyzer.
         * </p>
         * 
         * @param totalResolvedFindings
         *        The number of resolved findings for the specified external access analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalResolvedFindings(Integer totalResolvedFindings);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, ResourceTypeDetails> resourceTypeStatistics = DefaultSdkAutoConstructMap.getInstance();

        private Integer totalActiveFindings;

        private Integer totalArchivedFindings;

        private Integer totalResolvedFindings;

        private BuilderImpl() {
        }

        private BuilderImpl(ExternalAccessFindingsStatistics model) {
            resourceTypeStatisticsWithStrings(model.resourceTypeStatistics);
            totalActiveFindings(model.totalActiveFindings);
            totalArchivedFindings(model.totalArchivedFindings);
            totalResolvedFindings(model.totalResolvedFindings);
        }

        public final Map<String, ResourceTypeDetails.Builder> getResourceTypeStatistics() {
            Map<String, ResourceTypeDetails.Builder> result = ResourceTypeStatisticsMapCopier
                    .copyToBuilder(this.resourceTypeStatistics);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setResourceTypeStatistics(Map<String, ResourceTypeDetails.BuilderImpl> resourceTypeStatistics) {
            this.resourceTypeStatistics = ResourceTypeStatisticsMapCopier.copyFromBuilder(resourceTypeStatistics);
        }

        @Override
        public final Builder resourceTypeStatisticsWithStrings(Map<String, ResourceTypeDetails> resourceTypeStatistics) {
            this.resourceTypeStatistics = ResourceTypeStatisticsMapCopier.copy(resourceTypeStatistics);
            return this;
        }

        @Override
        public final Builder resourceTypeStatistics(Map<ResourceType, ResourceTypeDetails> resourceTypeStatistics) {
            this.resourceTypeStatistics = ResourceTypeStatisticsMapCopier.copyEnumToString(resourceTypeStatistics);
            return this;
        }

        public final Integer getTotalActiveFindings() {
            return totalActiveFindings;
        }

        public final void setTotalActiveFindings(Integer totalActiveFindings) {
            this.totalActiveFindings = totalActiveFindings;
        }

        @Override
        public final Builder totalActiveFindings(Integer totalActiveFindings) {
            this.totalActiveFindings = totalActiveFindings;
            return this;
        }

        public final Integer getTotalArchivedFindings() {
            return totalArchivedFindings;
        }

        public final void setTotalArchivedFindings(Integer totalArchivedFindings) {
            this.totalArchivedFindings = totalArchivedFindings;
        }

        @Override
        public final Builder totalArchivedFindings(Integer totalArchivedFindings) {
            this.totalArchivedFindings = totalArchivedFindings;
            return this;
        }

        public final Integer getTotalResolvedFindings() {
            return totalResolvedFindings;
        }

        public final void setTotalResolvedFindings(Integer totalResolvedFindings) {
            this.totalResolvedFindings = totalResolvedFindings;
        }

        @Override
        public final Builder totalResolvedFindings(Integer totalResolvedFindings) {
            this.totalResolvedFindings = totalResolvedFindings;
            return this;
        }

        @Override
        public ExternalAccessFindingsStatistics build() {
            return new ExternalAccessFindingsStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
