/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.accessanalyzer.AccessAnalyzerAsyncClient;
import software.amazon.awssdk.services.accessanalyzer.internal.UserAgentUtils;
import software.amazon.awssdk.services.accessanalyzer.model.FindingDetails;
import software.amazon.awssdk.services.accessanalyzer.model.GetFindingV2Request;
import software.amazon.awssdk.services.accessanalyzer.model.GetFindingV2Response;

public class GetFindingV2Publisher
implements SdkPublisher<GetFindingV2Response> {
    private final AccessAnalyzerAsyncClient client;
    private final GetFindingV2Request firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetFindingV2Publisher(AccessAnalyzerAsyncClient client, GetFindingV2Request firstRequest) {
        this(client, firstRequest, false);
    }

    private GetFindingV2Publisher(AccessAnalyzerAsyncClient client, GetFindingV2Request firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetFindingV2ResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetFindingV2Response> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FindingDetails> findingDetails() {
        Function<GetFindingV2Response, Iterator> getIterator = response -> {
            if (response != null && response.findingDetails() != null) {
                return response.findingDetails().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetFindingV2ResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetFindingV2ResponseFetcher
    implements AsyncPageFetcher<GetFindingV2Response> {
        private GetFindingV2ResponseFetcher() {
        }

        public boolean hasNextPage(GetFindingV2Response previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetFindingV2Response> nextPage(GetFindingV2Response previousPage) {
            if (previousPage == null) {
                return GetFindingV2Publisher.this.client.getFindingV2(GetFindingV2Publisher.this.firstRequest);
            }
            return GetFindingV2Publisher.this.client.getFindingV2((GetFindingV2Request)((Object)GetFindingV2Publisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

