/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.accessanalyzer.model.FindingStatus;
import software.amazon.awssdk.services.accessanalyzer.model.FindingType;
import software.amazon.awssdk.services.accessanalyzer.model.ResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FindingSummaryV2
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FindingSummaryV2> {
    private static final SdkField<Instant> ANALYZED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("analyzedAt").getter(FindingSummaryV2.getter(FindingSummaryV2::analyzedAt)).setter(FindingSummaryV2.setter(Builder::analyzedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analyzedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(FindingSummaryV2.getter(FindingSummaryV2::createdAt)).setter(FindingSummaryV2.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("error").getter(FindingSummaryV2.getter(FindingSummaryV2::error)).setter(FindingSummaryV2.setter(Builder::error)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(FindingSummaryV2.getter(FindingSummaryV2::id)).setter(FindingSummaryV2.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resource").getter(FindingSummaryV2.getter(FindingSummaryV2::resource)).setter(FindingSummaryV2.setter(Builder::resource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(FindingSummaryV2.getter(FindingSummaryV2::resourceTypeAsString)).setter(FindingSummaryV2.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<String> RESOURCE_OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceOwnerAccount").getter(FindingSummaryV2.getter(FindingSummaryV2::resourceOwnerAccount)).setter(FindingSummaryV2.setter(Builder::resourceOwnerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceOwnerAccount").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(FindingSummaryV2.getter(FindingSummaryV2::statusAsString)).setter(FindingSummaryV2.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(FindingSummaryV2.getter(FindingSummaryV2::updatedAt)).setter(FindingSummaryV2.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> FINDING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("findingType").getter(FindingSummaryV2.getter(FindingSummaryV2::findingTypeAsString)).setter(FindingSummaryV2.setter(Builder::findingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYZED_AT_FIELD, CREATED_AT_FIELD, ERROR_FIELD, ID_FIELD, RESOURCE_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_OWNER_ACCOUNT_FIELD, STATUS_FIELD, UPDATED_AT_FIELD, FINDING_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FindingSummaryV2.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant analyzedAt;
    private final Instant createdAt;
    private final String error;
    private final String id;
    private final String resource;
    private final String resourceType;
    private final String resourceOwnerAccount;
    private final String status;
    private final Instant updatedAt;
    private final String findingType;

    private FindingSummaryV2(BuilderImpl builder) {
        this.analyzedAt = builder.analyzedAt;
        this.createdAt = builder.createdAt;
        this.error = builder.error;
        this.id = builder.id;
        this.resource = builder.resource;
        this.resourceType = builder.resourceType;
        this.resourceOwnerAccount = builder.resourceOwnerAccount;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
        this.findingType = builder.findingType;
    }

    public final Instant analyzedAt() {
        return this.analyzedAt;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String error() {
        return this.error;
    }

    public final String id() {
        return this.id;
    }

    public final String resource() {
        return this.resource;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final String resourceOwnerAccount() {
        return this.resourceOwnerAccount;
    }

    public final FindingStatus status() {
        return FindingStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final FindingType findingType() {
        return FindingType.fromValue(this.findingType);
    }

    public final String findingTypeAsString() {
        return this.findingType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.analyzedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceOwnerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingSummaryV2)) {
            return false;
        }
        FindingSummaryV2 other = (FindingSummaryV2)obj;
        return Objects.equals(this.analyzedAt(), other.analyzedAt()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.resource(), other.resource()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.resourceOwnerAccount(), other.resourceOwnerAccount()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.findingTypeAsString(), other.findingTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FindingSummaryV2").add("AnalyzedAt", (Object)this.analyzedAt()).add("CreatedAt", (Object)this.createdAt()).add("Error", (Object)this.error()).add("Id", (Object)this.id()).add("Resource", (Object)this.resource()).add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceOwnerAccount", (Object)this.resourceOwnerAccount()).add("Status", (Object)this.statusAsString()).add("UpdatedAt", (Object)this.updatedAt()).add("FindingType", (Object)this.findingTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "analyzedAt": {
                return Optional.ofNullable(clazz.cast(this.analyzedAt()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "resourceOwnerAccount": {
                return Optional.ofNullable(clazz.cast(this.resourceOwnerAccount()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "findingType": {
                return Optional.ofNullable(clazz.cast(this.findingTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("analyzedAt", ANALYZED_AT_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("error", ERROR_FIELD);
        map.put("id", ID_FIELD);
        map.put("resource", RESOURCE_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("resourceOwnerAccount", RESOURCE_OWNER_ACCOUNT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("findingType", FINDING_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FindingSummaryV2, T> g) {
        return obj -> g.apply((FindingSummaryV2)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant analyzedAt;
        private Instant createdAt;
        private String error;
        private String id;
        private String resource;
        private String resourceType;
        private String resourceOwnerAccount;
        private String status;
        private Instant updatedAt;
        private String findingType;

        private BuilderImpl() {
        }

        private BuilderImpl(FindingSummaryV2 model) {
            this.analyzedAt(model.analyzedAt);
            this.createdAt(model.createdAt);
            this.error(model.error);
            this.id(model.id);
            this.resource(model.resource);
            this.resourceType(model.resourceType);
            this.resourceOwnerAccount(model.resourceOwnerAccount);
            this.status(model.status);
            this.updatedAt(model.updatedAt);
            this.findingType(model.findingType);
        }

        public final Instant getAnalyzedAt() {
            return this.analyzedAt;
        }

        public final void setAnalyzedAt(Instant analyzedAt) {
            this.analyzedAt = analyzedAt;
        }

        @Override
        public final Builder analyzedAt(Instant analyzedAt) {
            this.analyzedAt = analyzedAt;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getError() {
            return this.error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getResource() {
            return this.resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getResourceOwnerAccount() {
            return this.resourceOwnerAccount;
        }

        public final void setResourceOwnerAccount(String resourceOwnerAccount) {
            this.resourceOwnerAccount = resourceOwnerAccount;
        }

        @Override
        public final Builder resourceOwnerAccount(String resourceOwnerAccount) {
            this.resourceOwnerAccount = resourceOwnerAccount;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FindingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getFindingType() {
            return this.findingType;
        }

        public final void setFindingType(String findingType) {
            this.findingType = findingType;
        }

        @Override
        public final Builder findingType(String findingType) {
            this.findingType = findingType;
            return this;
        }

        @Override
        public final Builder findingType(FindingType findingType) {
            this.findingType(findingType == null ? null : findingType.toString());
            return this;
        }

        public FindingSummaryV2 build() {
            return new FindingSummaryV2(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FindingSummaryV2> {
        public Builder analyzedAt(Instant var1);

        public Builder createdAt(Instant var1);

        public Builder error(String var1);

        public Builder id(String var1);

        public Builder resource(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder resourceOwnerAccount(String var1);

        public Builder status(String var1);

        public Builder status(FindingStatus var1);

        public Builder updatedAt(Instant var1);

        public Builder findingType(String var1);

        public Builder findingType(FindingType var1);
    }
}

