/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.accessanalyzer.model.AccessAnalyzerRequest;
import software.amazon.awssdk.services.accessanalyzer.model.Locale;
import software.amazon.awssdk.services.accessanalyzer.model.PolicyType;
import software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidatePolicyRequest
extends AccessAnalyzerRequest
implements ToCopyableBuilder<Builder, ValidatePolicyRequest> {
    private static final SdkField<String> LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("locale").getter(ValidatePolicyRequest.getter(ValidatePolicyRequest::localeAsString)).setter(ValidatePolicyRequest.setter(Builder::locale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locale").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ValidatePolicyRequest.getter(ValidatePolicyRequest::maxResults)).setter(ValidatePolicyRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ValidatePolicyRequest.getter(ValidatePolicyRequest::nextToken)).setter(ValidatePolicyRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyDocument").getter(ValidatePolicyRequest.getter(ValidatePolicyRequest::policyDocument)).setter(ValidatePolicyRequest.setter(Builder::policyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDocument").build()}).build();
    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyType").getter(ValidatePolicyRequest.getter(ValidatePolicyRequest::policyTypeAsString)).setter(ValidatePolicyRequest.setter(Builder::policyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyType").build()}).build();
    private static final SdkField<String> VALIDATE_POLICY_RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("validatePolicyResourceType").getter(ValidatePolicyRequest.getter(ValidatePolicyRequest::validatePolicyResourceTypeAsString)).setter(ValidatePolicyRequest.setter(Builder::validatePolicyResourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validatePolicyResourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCALE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, POLICY_DOCUMENT_FIELD, POLICY_TYPE_FIELD, VALIDATE_POLICY_RESOURCE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ValidatePolicyRequest.memberNameToFieldInitializer();
    private final String locale;
    private final Integer maxResults;
    private final String nextToken;
    private final String policyDocument;
    private final String policyType;
    private final String validatePolicyResourceType;

    private ValidatePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.locale = builder.locale;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.policyDocument = builder.policyDocument;
        this.policyType = builder.policyType;
        this.validatePolicyResourceType = builder.validatePolicyResourceType;
    }

    public final Locale locale() {
        return Locale.fromValue(this.locale);
    }

    public final String localeAsString() {
        return this.locale;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String policyDocument() {
        return this.policyDocument;
    }

    public final PolicyType policyType() {
        return PolicyType.fromValue(this.policyType);
    }

    public final String policyTypeAsString() {
        return this.policyType;
    }

    public final ValidatePolicyResourceType validatePolicyResourceType() {
        return ValidatePolicyResourceType.fromValue(this.validatePolicyResourceType);
    }

    public final String validatePolicyResourceTypeAsString() {
        return this.validatePolicyResourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.localeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.validatePolicyResourceTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidatePolicyRequest)) {
            return false;
        }
        ValidatePolicyRequest other = (ValidatePolicyRequest)((Object)obj);
        return Objects.equals(this.localeAsString(), other.localeAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.policyDocument(), other.policyDocument()) && Objects.equals(this.policyTypeAsString(), other.policyTypeAsString()) && Objects.equals(this.validatePolicyResourceTypeAsString(), other.validatePolicyResourceTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ValidatePolicyRequest").add("Locale", (Object)this.localeAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("PolicyDocument", (Object)this.policyDocument()).add("PolicyType", (Object)this.policyTypeAsString()).add("ValidatePolicyResourceType", (Object)this.validatePolicyResourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "locale": {
                return Optional.ofNullable(clazz.cast(this.localeAsString()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "policyDocument": {
                return Optional.ofNullable(clazz.cast(this.policyDocument()));
            }
            case "policyType": {
                return Optional.ofNullable(clazz.cast(this.policyTypeAsString()));
            }
            case "validatePolicyResourceType": {
                return Optional.ofNullable(clazz.cast(this.validatePolicyResourceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("locale", LOCALE_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("policyDocument", POLICY_DOCUMENT_FIELD);
        map.put("policyType", POLICY_TYPE_FIELD);
        map.put("validatePolicyResourceType", VALIDATE_POLICY_RESOURCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValidatePolicyRequest, T> g) {
        return obj -> g.apply((ValidatePolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AccessAnalyzerRequest.BuilderImpl
    implements Builder {
        private String locale;
        private Integer maxResults;
        private String nextToken;
        private String policyDocument;
        private String policyType;
        private String validatePolicyResourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidatePolicyRequest model) {
            super(model);
            this.locale(model.locale);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.policyDocument(model.policyDocument);
            this.policyType(model.policyType);
            this.validatePolicyResourceType(model.validatePolicyResourceType);
        }

        public final String getLocale() {
            return this.locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public final Builder locale(Locale locale) {
            this.locale(locale == null ? null : locale.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final String getPolicyType() {
            return this.policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final String getValidatePolicyResourceType() {
            return this.validatePolicyResourceType;
        }

        public final void setValidatePolicyResourceType(String validatePolicyResourceType) {
            this.validatePolicyResourceType = validatePolicyResourceType;
        }

        @Override
        public final Builder validatePolicyResourceType(String validatePolicyResourceType) {
            this.validatePolicyResourceType = validatePolicyResourceType;
            return this;
        }

        @Override
        public final Builder validatePolicyResourceType(ValidatePolicyResourceType validatePolicyResourceType) {
            this.validatePolicyResourceType(validatePolicyResourceType == null ? null : validatePolicyResourceType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ValidatePolicyRequest build() {
            return new ValidatePolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AccessAnalyzerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ValidatePolicyRequest> {
        public Builder locale(String var1);

        public Builder locale(Locale var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder policyDocument(String var1);

        public Builder policyType(String var1);

        public Builder policyType(PolicyType var1);

        public Builder validatePolicyResourceType(String var1);

        public Builder validatePolicyResourceType(ValidatePolicyResourceType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

