/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.endpoints.internal;

import java.net.MalformedURLException;
import java.net.URL;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.utils.StringUtils;

@SdkInternalApi
public final class RuleUrl {
    private final String scheme;
    private final String authority;
    private final String path;
    private final String normalizedPath;
    private final boolean isIp;

    RuleUrl(String scheme, String authority, String path, String normalizedPath, boolean isIp) {
        this.scheme = scheme;
        this.authority = authority;
        this.path = path;
        this.normalizedPath = normalizedPath;
        this.isIp = isIp;
    }

    public String scheme() {
        return this.scheme;
    }

    public String authority() {
        return this.authority;
    }

    public String path() {
        return this.path;
    }

    public String normalizedPath() {
        return this.normalizedPath;
    }

    public boolean isIp() {
        return this.isIp;
    }

    public static RuleUrl parse(String url) throws MalformedURLException {
        URL parsed = new URL(url);
        String path = parsed.getPath();
        if (parsed.getQuery() != null) {
            return null;
        }
        String host = parsed.getHost();
        boolean isIpAddr = RuleUrl.isIpAddr(host);
        String normalizedPath = RuleUrl.normalizePath(path);
        return new RuleUrl(parsed.getProtocol(), parsed.getAuthority(), path, normalizedPath, isIpAddr);
    }

    static boolean isIpAddr(String host) {
        if (host.startsWith("[") && host.endsWith("]")) {
            return true;
        }
        int from = 0;
        int segments = 0;
        boolean done = false;
        while (!done) {
            char ch1;
            char ch0;
            int index = host.indexOf(46, from);
            if (index == -1) {
                if (segments != 3) {
                    return false;
                }
                index = host.length();
                done = true;
            } else if (segments == 3) {
                return false;
            }
            int length = index - from;
            if (length == 1) {
                ch0 = host.charAt(from);
                if (ch0 < '0' || ch0 > '9') {
                    return false;
                }
            } else if (length == 2) {
                ch0 = host.charAt(from);
                ch1 = host.charAt(from + 1);
                if (ch0 <= '0' || ch0 > '9' || ch1 < '0' || ch1 > '9') {
                    return false;
                }
            } else if (length == 3) {
                ch0 = host.charAt(from);
                ch1 = host.charAt(from + 1);
                char ch2 = host.charAt(from + 2);
                if (ch0 <= '0' || ch0 > '9' || ch1 < '0' || ch1 > '9' || ch2 < '0' || ch2 > '9') {
                    return false;
                }
                int value = (ch0 - 48) * 100 + (ch1 - 48) * 10 + (ch2 - 48);
                if (value > 255) {
                    return false;
                }
            } else {
                return false;
            }
            from = index + 1;
            ++segments;
        }
        return true;
    }

    static String normalizePath(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return "/";
        }
        boolean startsWithSlash = path.startsWith("/");
        boolean endsWithSlash = path.endsWith("/");
        if (startsWithSlash && endsWithSlash) {
            return path;
        }
        StringBuilder builder = new StringBuilder();
        if (!startsWithSlash) {
            builder.append("/");
        }
        builder.append(path);
        if (!endsWithSlash) {
            builder.append("/");
        }
        return builder.toString();
    }
}

