/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewStatusReasonCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccessPreviewStatusReason
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccessPreviewStatusReason> {
    private static final SdkField<String> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("code").getter(AccessPreviewStatusReason.getter(AccessPreviewStatusReason::codeAsString)).setter(AccessPreviewStatusReason.setter(Builder::code)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccessPreviewStatusReason.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String code;

    private AccessPreviewStatusReason(BuilderImpl builder) {
        this.code = builder.code;
    }

    public final AccessPreviewStatusReasonCode code() {
        return AccessPreviewStatusReasonCode.fromValue(this.code);
    }

    public final String codeAsString() {
        return this.code;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessPreviewStatusReason)) {
            return false;
        }
        AccessPreviewStatusReason other = (AccessPreviewStatusReason)obj;
        return Objects.equals(this.codeAsString(), other.codeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AccessPreviewStatusReason").add("Code", (Object)this.codeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "code": {
                return Optional.ofNullable(clazz.cast(this.codeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("code", CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccessPreviewStatusReason, T> g) {
        return obj -> g.apply((AccessPreviewStatusReason)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String code;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessPreviewStatusReason model) {
            this.code(model.code);
        }

        public final String getCode() {
            return this.code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(AccessPreviewStatusReasonCode code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        public AccessPreviewStatusReason build() {
            return new AccessPreviewStatusReason(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccessPreviewStatusReason> {
        public Builder code(String var1);

        public Builder code(AccessPreviewStatusReasonCode var1);
    }
}

