/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CheckNoPublicAccessResult {
    PASS("PASS"),
    FAIL("FAIL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CheckNoPublicAccessResult> VALUE_MAP;
    private final String value;

    private CheckNoPublicAccessResult(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CheckNoPublicAccessResult fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CheckNoPublicAccessResult> knownValues() {
        EnumSet<CheckNoPublicAccessResult> knownValues = EnumSet.allOf(CheckNoPublicAccessResult.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CheckNoPublicAccessResult.class, CheckNoPublicAccessResult::toString);
    }
}

