/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DynamodbStreamConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DynamodbStreamConfiguration> {
    private static final SdkField<String> STREAM_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("streamPolicy").getter(DynamodbStreamConfiguration.getter(DynamodbStreamConfiguration::streamPolicy)).setter(DynamodbStreamConfiguration.setter(Builder::streamPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("streamPolicy", STREAM_POLICY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String streamPolicy;

    private DynamodbStreamConfiguration(BuilderImpl builder) {
        this.streamPolicy = builder.streamPolicy;
    }

    public final String streamPolicy() {
        return this.streamPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamPolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamodbStreamConfiguration)) {
            return false;
        }
        DynamodbStreamConfiguration other = (DynamodbStreamConfiguration)obj;
        return Objects.equals(this.streamPolicy(), other.streamPolicy());
    }

    public final String toString() {
        return ToString.builder((String)"DynamodbStreamConfiguration").add("StreamPolicy", (Object)this.streamPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "streamPolicy": {
                return Optional.ofNullable(clazz.cast(this.streamPolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DynamodbStreamConfiguration, T> g) {
        return obj -> g.apply((DynamodbStreamConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String streamPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(DynamodbStreamConfiguration model) {
            this.streamPolicy(model.streamPolicy);
        }

        public final String getStreamPolicy() {
            return this.streamPolicy;
        }

        public final void setStreamPolicy(String streamPolicy) {
            this.streamPolicy = streamPolicy;
        }

        @Override
        public final Builder streamPolicy(String streamPolicy) {
            this.streamPolicy = streamPolicy;
            return this;
        }

        public DynamodbStreamConfiguration build() {
            return new DynamodbStreamConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DynamodbStreamConfiguration> {
        public Builder streamPolicy(String var1);
    }
}

