/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.accessanalyzer.model.AclGrantee;
import software.amazon.awssdk.services.accessanalyzer.model.AclPermission;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3BucketAclGrantConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3BucketAclGrantConfiguration> {
    private static final SdkField<String> PERMISSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("permission").getter(S3BucketAclGrantConfiguration.getter(S3BucketAclGrantConfiguration::permissionAsString)).setter(S3BucketAclGrantConfiguration.setter(Builder::permission)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permission").build()}).build();
    private static final SdkField<AclGrantee> GRANTEE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("grantee").getter(S3BucketAclGrantConfiguration.getter(S3BucketAclGrantConfiguration::grantee)).setter(S3BucketAclGrantConfiguration.setter(Builder::grantee)).constructor(AclGrantee::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grantee").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERMISSION_FIELD, GRANTEE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("permission", PERMISSION_FIELD);
            this.put("grantee", GRANTEE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String permission;
    private final AclGrantee grantee;

    private S3BucketAclGrantConfiguration(BuilderImpl builder) {
        this.permission = builder.permission;
        this.grantee = builder.grantee;
    }

    public final AclPermission permission() {
        return AclPermission.fromValue(this.permission);
    }

    public final String permissionAsString() {
        return this.permission;
    }

    public final AclGrantee grantee() {
        return this.grantee;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantee());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3BucketAclGrantConfiguration)) {
            return false;
        }
        S3BucketAclGrantConfiguration other = (S3BucketAclGrantConfiguration)obj;
        return Objects.equals(this.permissionAsString(), other.permissionAsString()) && Objects.equals(this.grantee(), other.grantee());
    }

    public final String toString() {
        return ToString.builder((String)"S3BucketAclGrantConfiguration").add("Permission", (Object)this.permissionAsString()).add("Grantee", (Object)this.grantee()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "permission": {
                return Optional.ofNullable(clazz.cast(this.permissionAsString()));
            }
            case "grantee": {
                return Optional.ofNullable(clazz.cast(this.grantee()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<S3BucketAclGrantConfiguration, T> g) {
        return obj -> g.apply((S3BucketAclGrantConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String permission;
        private AclGrantee grantee;

        private BuilderImpl() {
        }

        private BuilderImpl(S3BucketAclGrantConfiguration model) {
            this.permission(model.permission);
            this.grantee(model.grantee);
        }

        public final String getPermission() {
            return this.permission;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        @Override
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public final Builder permission(AclPermission permission) {
            this.permission(permission == null ? null : permission.toString());
            return this;
        }

        public final AclGrantee.Builder getGrantee() {
            return this.grantee != null ? this.grantee.toBuilder() : null;
        }

        public final void setGrantee(AclGrantee.BuilderImpl grantee) {
            this.grantee = grantee != null ? grantee.build() : null;
        }

        @Override
        public final Builder grantee(AclGrantee grantee) {
            this.grantee = grantee;
            return this;
        }

        public S3BucketAclGrantConfiguration build() {
            return new S3BucketAclGrantConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3BucketAclGrantConfiguration> {
        public Builder permission(String var1);

        public Builder permission(AclPermission var1);

        public Builder grantee(AclGrantee var1);

        default public Builder grantee(Consumer<AclGrantee.Builder> grantee) {
            return this.grantee((AclGrantee)((AclGrantee.Builder)AclGrantee.builder().applyMutation(grantee)).build());
        }
    }
}

