/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.accessanalyzer.AccessAnalyzerClient;
import software.amazon.awssdk.services.accessanalyzer.internal.UserAgentUtils;
import software.amazon.awssdk.services.accessanalyzer.model.AnalyzedResourceSummary;
import software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesResponse;

public class ListAnalyzedResourcesIterable
implements SdkIterable<ListAnalyzedResourcesResponse> {
    private final AccessAnalyzerClient client;
    private final ListAnalyzedResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAnalyzedResourcesIterable(AccessAnalyzerClient client, ListAnalyzedResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAnalyzedResourcesResponseFetcher();
    }

    public Iterator<ListAnalyzedResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AnalyzedResourceSummary> analyzedResources() {
        Function<ListAnalyzedResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.analyzedResources() != null) {
                return response.analyzedResources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAnalyzedResourcesResponseFetcher
    implements SyncPageFetcher<ListAnalyzedResourcesResponse> {
        private ListAnalyzedResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListAnalyzedResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAnalyzedResourcesResponse nextPage(ListAnalyzedResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListAnalyzedResourcesIterable.this.client.listAnalyzedResources(ListAnalyzedResourcesIterable.this.firstRequest);
            }
            return ListAnalyzedResourcesIterable.this.client.listAnalyzedResources((ListAnalyzedResourcesRequest)((Object)ListAnalyzedResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

