/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.accessanalyzer.AccessAnalyzerClient;
import software.amazon.awssdk.services.accessanalyzer.internal.UserAgentUtils;
import software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyFinding;
import software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyResponse;

public class ValidatePolicyIterable
implements SdkIterable<ValidatePolicyResponse> {
    private final AccessAnalyzerClient client;
    private final ValidatePolicyRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ValidatePolicyIterable(AccessAnalyzerClient client, ValidatePolicyRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ValidatePolicyResponseFetcher();
    }

    public Iterator<ValidatePolicyResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ValidatePolicyFinding> findings() {
        Function<ValidatePolicyResponse, Iterator> getIterator = response -> {
            if (response != null && response.findings() != null) {
                return response.findings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ValidatePolicyResponseFetcher
    implements SyncPageFetcher<ValidatePolicyResponse> {
        private ValidatePolicyResponseFetcher() {
        }

        public boolean hasNextPage(ValidatePolicyResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ValidatePolicyResponse nextPage(ValidatePolicyResponse previousPage) {
            if (previousPage == null) {
                return ValidatePolicyIterable.this.client.validatePolicy(ValidatePolicyIterable.this.firstRequest);
            }
            return ValidatePolicyIterable.this.client.validatePolicy((ValidatePolicyRequest)((Object)ValidatePolicyIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

