/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.accessanalyzer.model.KmsConstraintsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KmsGrantConstraints
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KmsGrantConstraints> {
    private static final SdkField<Map<String, String>> ENCRYPTION_CONTEXT_EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("encryptionContextEquals").getter(KmsGrantConstraints.getter(KmsGrantConstraints::encryptionContextEquals)).setter(KmsGrantConstraints.setter(Builder::encryptionContextEquals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionContextEquals").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> ENCRYPTION_CONTEXT_SUBSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("encryptionContextSubset").getter(KmsGrantConstraints.getter(KmsGrantConstraints::encryptionContextSubset)).setter(KmsGrantConstraints.setter(Builder::encryptionContextSubset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionContextSubset").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_CONTEXT_EQUALS_FIELD, ENCRYPTION_CONTEXT_SUBSET_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, String> encryptionContextEquals;
    private final Map<String, String> encryptionContextSubset;

    private KmsGrantConstraints(BuilderImpl builder) {
        this.encryptionContextEquals = builder.encryptionContextEquals;
        this.encryptionContextSubset = builder.encryptionContextSubset;
    }

    public final boolean hasEncryptionContextEquals() {
        return this.encryptionContextEquals != null && !(this.encryptionContextEquals instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> encryptionContextEquals() {
        return this.encryptionContextEquals;
    }

    public final boolean hasEncryptionContextSubset() {
        return this.encryptionContextSubset != null && !(this.encryptionContextSubset instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> encryptionContextSubset() {
        return this.encryptionContextSubset;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEncryptionContextEquals() ? this.encryptionContextEquals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEncryptionContextSubset() ? this.encryptionContextSubset() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KmsGrantConstraints)) {
            return false;
        }
        KmsGrantConstraints other = (KmsGrantConstraints)obj;
        return this.hasEncryptionContextEquals() == other.hasEncryptionContextEquals() && Objects.equals(this.encryptionContextEquals(), other.encryptionContextEquals()) && this.hasEncryptionContextSubset() == other.hasEncryptionContextSubset() && Objects.equals(this.encryptionContextSubset(), other.encryptionContextSubset());
    }

    public final String toString() {
        return ToString.builder((String)"KmsGrantConstraints").add("EncryptionContextEquals", this.hasEncryptionContextEquals() ? this.encryptionContextEquals() : null).add("EncryptionContextSubset", this.hasEncryptionContextSubset() ? this.encryptionContextSubset() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "encryptionContextEquals": {
                return Optional.ofNullable(clazz.cast(this.encryptionContextEquals()));
            }
            case "encryptionContextSubset": {
                return Optional.ofNullable(clazz.cast(this.encryptionContextSubset()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KmsGrantConstraints, T> g) {
        return obj -> g.apply((KmsGrantConstraints)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> encryptionContextEquals = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> encryptionContextSubset = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(KmsGrantConstraints model) {
            this.encryptionContextEquals(model.encryptionContextEquals);
            this.encryptionContextSubset(model.encryptionContextSubset);
        }

        public final Map<String, String> getEncryptionContextEquals() {
            if (this.encryptionContextEquals instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.encryptionContextEquals;
        }

        public final void setEncryptionContextEquals(Map<String, String> encryptionContextEquals) {
            this.encryptionContextEquals = KmsConstraintsMapCopier.copy(encryptionContextEquals);
        }

        @Override
        public final Builder encryptionContextEquals(Map<String, String> encryptionContextEquals) {
            this.encryptionContextEquals = KmsConstraintsMapCopier.copy(encryptionContextEquals);
            return this;
        }

        public final Map<String, String> getEncryptionContextSubset() {
            if (this.encryptionContextSubset instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.encryptionContextSubset;
        }

        public final void setEncryptionContextSubset(Map<String, String> encryptionContextSubset) {
            this.encryptionContextSubset = KmsConstraintsMapCopier.copy(encryptionContextSubset);
        }

        @Override
        public final Builder encryptionContextSubset(Map<String, String> encryptionContextSubset) {
            this.encryptionContextSubset = KmsConstraintsMapCopier.copy(encryptionContextSubset);
            return this;
        }

        public KmsGrantConstraints build() {
            return new KmsGrantConstraints(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KmsGrantConstraints> {
        public Builder encryptionContextEquals(Map<String, String> var1);

        public Builder encryptionContextSubset(Map<String, String> var1);
    }
}

