/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A span in a policy. The span consists of a start position (inclusive) and end position (exclusive).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Span implements SdkPojo, Serializable, ToCopyableBuilder<Span.Builder, Span> {
    private static final SdkField<Position> START_FIELD = SdkField.<Position> builder(MarshallingType.SDK_POJO)
            .memberName("start").getter(getter(Span::start)).setter(setter(Builder::start)).constructor(Position::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("start").build()).build();

    private static final SdkField<Position> END_FIELD = SdkField.<Position> builder(MarshallingType.SDK_POJO).memberName("end")
            .getter(getter(Span::end)).setter(setter(Builder::end)).constructor(Position::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("end").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_FIELD, END_FIELD));

    private static final long serialVersionUID = 1L;

    private final Position start;

    private final Position end;

    private Span(BuilderImpl builder) {
        this.start = builder.start;
        this.end = builder.end;
    }

    /**
     * <p>
     * The start position of the span (inclusive).
     * </p>
     * 
     * @return The start position of the span (inclusive).
     */
    public final Position start() {
        return start;
    }

    /**
     * <p>
     * The end position of the span (exclusive).
     * </p>
     * 
     * @return The end position of the span (exclusive).
     */
    public final Position end() {
        return end;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(start());
        hashCode = 31 * hashCode + Objects.hashCode(end());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Span)) {
            return false;
        }
        Span other = (Span) obj;
        return Objects.equals(start(), other.start()) && Objects.equals(end(), other.end());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Span").add("Start", start()).add("End", end()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "start":
            return Optional.ofNullable(clazz.cast(start()));
        case "end":
            return Optional.ofNullable(clazz.cast(end()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Span, T> g) {
        return obj -> g.apply((Span) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Span> {
        /**
         * <p>
         * The start position of the span (inclusive).
         * </p>
         * 
         * @param start
         *        The start position of the span (inclusive).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(Position start);

        /**
         * <p>
         * The start position of the span (inclusive).
         * </p>
         * This is a convenience method that creates an instance of the {@link Position.Builder} avoiding the need to
         * create one manually via {@link Position#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Position.Builder#build()} is called immediately and its result is
         * passed to {@link #start(Position)}.
         * 
         * @param start
         *        a consumer that will call methods on {@link Position.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #start(Position)
         */
        default Builder start(Consumer<Position.Builder> start) {
            return start(Position.builder().applyMutation(start).build());
        }

        /**
         * <p>
         * The end position of the span (exclusive).
         * </p>
         * 
         * @param end
         *        The end position of the span (exclusive).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(Position end);

        /**
         * <p>
         * The end position of the span (exclusive).
         * </p>
         * This is a convenience method that creates an instance of the {@link Position.Builder} avoiding the need to
         * create one manually via {@link Position#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Position.Builder#build()} is called immediately and its result is
         * passed to {@link #end(Position)}.
         * 
         * @param end
         *        a consumer that will call methods on {@link Position.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #end(Position)
         */
        default Builder end(Consumer<Position.Builder> end) {
            return end(Position.builder().applyMutation(end).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Position start;

        private Position end;

        private BuilderImpl() {
        }

        private BuilderImpl(Span model) {
            start(model.start);
            end(model.end);
        }

        public final Position.Builder getStart() {
            return start != null ? start.toBuilder() : null;
        }

        public final void setStart(Position.BuilderImpl start) {
            this.start = start != null ? start.build() : null;
        }

        @Override
        public final Builder start(Position start) {
            this.start = start;
            return this;
        }

        public final Position.Builder getEnd() {
            return end != null ? end.toBuilder() : null;
        }

        public final void setEnd(Position.BuilderImpl end) {
            this.end = end != null ? end.build() : null;
        }

        @Override
        public final Builder end(Position end) {
            this.end = end;
            return this;
        }

        @Override
        public Span build() {
            return new Span(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
