/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.accessanalyzer.model.KmsGrantConstraints;
import software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation;
import software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperationsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KmsGrantConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KmsGrantConfiguration> {
    private static final SdkField<List<String>> OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("operations").getter(KmsGrantConfiguration.getter(KmsGrantConfiguration::operationsAsStrings)).setter(KmsGrantConfiguration.setter(Builder::operationsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> GRANTEE_PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("granteePrincipal").getter(KmsGrantConfiguration.getter(KmsGrantConfiguration::granteePrincipal)).setter(KmsGrantConfiguration.setter(Builder::granteePrincipal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("granteePrincipal").build()}).build();
    private static final SdkField<String> RETIRING_PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("retiringPrincipal").getter(KmsGrantConfiguration.getter(KmsGrantConfiguration::retiringPrincipal)).setter(KmsGrantConfiguration.setter(Builder::retiringPrincipal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retiringPrincipal").build()}).build();
    private static final SdkField<KmsGrantConstraints> CONSTRAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("constraints").getter(KmsGrantConfiguration.getter(KmsGrantConfiguration::constraints)).setter(KmsGrantConfiguration.setter(Builder::constraints)).constructor(KmsGrantConstraints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("constraints").build()}).build();
    private static final SdkField<String> ISSUING_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("issuingAccount").getter(KmsGrantConfiguration.getter(KmsGrantConfiguration::issuingAccount)).setter(KmsGrantConfiguration.setter(Builder::issuingAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuingAccount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATIONS_FIELD, GRANTEE_PRINCIPAL_FIELD, RETIRING_PRINCIPAL_FIELD, CONSTRAINTS_FIELD, ISSUING_ACCOUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> operations;
    private final String granteePrincipal;
    private final String retiringPrincipal;
    private final KmsGrantConstraints constraints;
    private final String issuingAccount;

    private KmsGrantConfiguration(BuilderImpl builder) {
        this.operations = builder.operations;
        this.granteePrincipal = builder.granteePrincipal;
        this.retiringPrincipal = builder.retiringPrincipal;
        this.constraints = builder.constraints;
        this.issuingAccount = builder.issuingAccount;
    }

    public final List<KmsGrantOperation> operations() {
        return KmsGrantOperationsListCopier.copyStringToEnum(this.operations);
    }

    public final boolean hasOperations() {
        return this.operations != null && !(this.operations instanceof SdkAutoConstructList);
    }

    public final List<String> operationsAsStrings() {
        return this.operations;
    }

    public final String granteePrincipal() {
        return this.granteePrincipal;
    }

    public final String retiringPrincipal() {
        return this.retiringPrincipal;
    }

    public final KmsGrantConstraints constraints() {
        return this.constraints;
    }

    public final String issuingAccount() {
        return this.issuingAccount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperations() ? this.operationsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.granteePrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(this.retiringPrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(this.constraints());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuingAccount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KmsGrantConfiguration)) {
            return false;
        }
        KmsGrantConfiguration other = (KmsGrantConfiguration)obj;
        return this.hasOperations() == other.hasOperations() && Objects.equals(this.operationsAsStrings(), other.operationsAsStrings()) && Objects.equals(this.granteePrincipal(), other.granteePrincipal()) && Objects.equals(this.retiringPrincipal(), other.retiringPrincipal()) && Objects.equals(this.constraints(), other.constraints()) && Objects.equals(this.issuingAccount(), other.issuingAccount());
    }

    public final String toString() {
        return ToString.builder((String)"KmsGrantConfiguration").add("Operations", this.hasOperations() ? this.operationsAsStrings() : null).add("GranteePrincipal", (Object)this.granteePrincipal()).add("RetiringPrincipal", (Object)this.retiringPrincipal()).add("Constraints", (Object)this.constraints()).add("IssuingAccount", (Object)this.issuingAccount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "operations": {
                return Optional.ofNullable(clazz.cast(this.operationsAsStrings()));
            }
            case "granteePrincipal": {
                return Optional.ofNullable(clazz.cast(this.granteePrincipal()));
            }
            case "retiringPrincipal": {
                return Optional.ofNullable(clazz.cast(this.retiringPrincipal()));
            }
            case "constraints": {
                return Optional.ofNullable(clazz.cast(this.constraints()));
            }
            case "issuingAccount": {
                return Optional.ofNullable(clazz.cast(this.issuingAccount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KmsGrantConfiguration, T> g) {
        return obj -> g.apply((KmsGrantConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> operations = DefaultSdkAutoConstructList.getInstance();
        private String granteePrincipal;
        private String retiringPrincipal;
        private KmsGrantConstraints constraints;
        private String issuingAccount;

        private BuilderImpl() {
        }

        private BuilderImpl(KmsGrantConfiguration model) {
            this.operationsWithStrings(model.operations);
            this.granteePrincipal(model.granteePrincipal);
            this.retiringPrincipal(model.retiringPrincipal);
            this.constraints(model.constraints);
            this.issuingAccount(model.issuingAccount);
        }

        public final Collection<String> getOperations() {
            if (this.operations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.operations;
        }

        public final void setOperations(Collection<String> operations) {
            this.operations = KmsGrantOperationsListCopier.copy(operations);
        }

        @Override
        public final Builder operationsWithStrings(Collection<String> operations) {
            this.operations = KmsGrantOperationsListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationsWithStrings(String ... operations) {
            this.operationsWithStrings(Arrays.asList(operations));
            return this;
        }

        @Override
        public final Builder operations(Collection<KmsGrantOperation> operations) {
            this.operations = KmsGrantOperationsListCopier.copyEnumToString(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(KmsGrantOperation ... operations) {
            this.operations(Arrays.asList(operations));
            return this;
        }

        public final String getGranteePrincipal() {
            return this.granteePrincipal;
        }

        public final void setGranteePrincipal(String granteePrincipal) {
            this.granteePrincipal = granteePrincipal;
        }

        @Override
        public final Builder granteePrincipal(String granteePrincipal) {
            this.granteePrincipal = granteePrincipal;
            return this;
        }

        public final String getRetiringPrincipal() {
            return this.retiringPrincipal;
        }

        public final void setRetiringPrincipal(String retiringPrincipal) {
            this.retiringPrincipal = retiringPrincipal;
        }

        @Override
        public final Builder retiringPrincipal(String retiringPrincipal) {
            this.retiringPrincipal = retiringPrincipal;
            return this;
        }

        public final KmsGrantConstraints.Builder getConstraints() {
            return this.constraints != null ? this.constraints.toBuilder() : null;
        }

        public final void setConstraints(KmsGrantConstraints.BuilderImpl constraints) {
            this.constraints = constraints != null ? constraints.build() : null;
        }

        @Override
        public final Builder constraints(KmsGrantConstraints constraints) {
            this.constraints = constraints;
            return this;
        }

        public final String getIssuingAccount() {
            return this.issuingAccount;
        }

        public final void setIssuingAccount(String issuingAccount) {
            this.issuingAccount = issuingAccount;
        }

        @Override
        public final Builder issuingAccount(String issuingAccount) {
            this.issuingAccount = issuingAccount;
            return this;
        }

        public KmsGrantConfiguration build() {
            return new KmsGrantConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KmsGrantConfiguration> {
        public Builder operationsWithStrings(Collection<String> var1);

        public Builder operationsWithStrings(String ... var1);

        public Builder operations(Collection<KmsGrantOperation> var1);

        public Builder operations(KmsGrantOperation ... var1);

        public Builder granteePrincipal(String var1);

        public Builder retiringPrincipal(String var1);

        public Builder constraints(KmsGrantConstraints var1);

        default public Builder constraints(Consumer<KmsGrantConstraints.Builder> constraints) {
            return this.constraints((KmsGrantConstraints)((KmsGrantConstraints.Builder)KmsGrantConstraints.builder().applyMutation(constraints)).build());
        }

        public Builder issuingAccount(String var1);
    }
}

