/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum JobErrorCode {
    AUTHORIZATION_ERROR("AUTHORIZATION_ERROR"),
    RESOURCE_NOT_FOUND_ERROR("RESOURCE_NOT_FOUND_ERROR"),
    SERVICE_QUOTA_EXCEEDED_ERROR("SERVICE_QUOTA_EXCEEDED_ERROR"),
    SERVICE_ERROR("SERVICE_ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private JobErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static JobErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(JobErrorCode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<JobErrorCode> knownValues() {
        return Stream.of(JobErrorCode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

