/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.accessanalyzer.model.Substring;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PathElement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PathElement> {
    private static final SdkField<Integer> INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("index").getter(PathElement.getter(PathElement::index)).setter(PathElement.setter(Builder::index)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("index").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("key").getter(PathElement.getter(PathElement::key)).setter(PathElement.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()}).build();
    private static final SdkField<Substring> SUBSTRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("substring").getter(PathElement.getter(PathElement::substring)).setter(PathElement.setter(Builder::substring)).constructor(Substring::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("substring").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("value").getter(PathElement.getter(PathElement::value)).setter(PathElement.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_FIELD, KEY_FIELD, SUBSTRING_FIELD, VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer index;
    private final String key;
    private final Substring substring;
    private final String value;
    private final Type type;

    private PathElement(BuilderImpl builder) {
        this.index = builder.index;
        this.key = builder.key;
        this.substring = builder.substring;
        this.value = builder.value;
        this.type = builder.type;
    }

    public final Integer index() {
        return this.index;
    }

    public final String key() {
        return this.key;
    }

    public final Substring substring() {
        return this.substring;
    }

    public final String value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.index());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.substring());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PathElement)) {
            return false;
        }
        PathElement other = (PathElement)obj;
        return Objects.equals(this.index(), other.index()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.substring(), other.substring()) && Objects.equals(this.value(), other.value());
    }

    public final String toString() {
        return ToString.builder((String)"PathElement").add("Index", (Object)this.index()).add("Key", (Object)this.key()).add("Substring", (Object)this.substring()).add("Value", (Object)this.value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "index": {
                return Optional.ofNullable(clazz.cast(this.index()));
            }
            case "key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "substring": {
                return Optional.ofNullable(clazz.cast(this.substring()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public static PathElement fromIndex(Integer index) {
        return (PathElement)PathElement.builder().index(index).build();
    }

    public static PathElement fromKey(String key) {
        return (PathElement)PathElement.builder().key(key).build();
    }

    public static PathElement fromSubstring(Substring substring) {
        return (PathElement)PathElement.builder().substring(substring).build();
    }

    public static PathElement fromSubstring(Consumer<Substring.Builder> substring) {
        Substring.Builder builder = Substring.builder();
        substring.accept(builder);
        return PathElement.fromSubstring((Substring)builder.build());
    }

    public static PathElement fromValue(String value) {
        return (PathElement)PathElement.builder().value(value).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PathElement, T> g) {
        return obj -> g.apply((PathElement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        INDEX,
        KEY,
        SUBSTRING,
        VALUE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private Integer index;
        private String key;
        private Substring substring;
        private String value;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PathElement model) {
            this.index(model.index);
            this.key(model.key);
            this.substring(model.substring);
            this.value(model.value);
        }

        public final Integer getIndex() {
            return this.index;
        }

        public final void setIndex(Integer index) {
            Integer oldValue = this.index;
            this.index = index;
            this.handleUnionValueChange(Type.INDEX, oldValue, this.index);
        }

        @Override
        @Transient
        public final Builder index(Integer index) {
            Integer oldValue = this.index;
            this.index = index;
            this.handleUnionValueChange(Type.INDEX, oldValue, this.index);
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            String oldValue = this.key;
            this.key = key;
            this.handleUnionValueChange(Type.KEY, oldValue, this.key);
        }

        @Override
        @Transient
        public final Builder key(String key) {
            String oldValue = this.key;
            this.key = key;
            this.handleUnionValueChange(Type.KEY, oldValue, this.key);
            return this;
        }

        public final Substring.Builder getSubstring() {
            return this.substring != null ? this.substring.toBuilder() : null;
        }

        public final void setSubstring(Substring.BuilderImpl substring) {
            Substring oldValue = this.substring;
            this.substring = substring != null ? substring.build() : null;
            this.handleUnionValueChange(Type.SUBSTRING, oldValue, this.substring);
        }

        @Override
        @Transient
        public final Builder substring(Substring substring) {
            Substring oldValue = this.substring;
            this.substring = substring;
            this.handleUnionValueChange(Type.SUBSTRING, oldValue, this.substring);
            return this;
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            String oldValue = this.value;
            this.value = value;
            this.handleUnionValueChange(Type.VALUE, oldValue, this.value);
        }

        @Override
        @Transient
        public final Builder value(String value) {
            String oldValue = this.value;
            this.value = value;
            this.handleUnionValueChange(Type.VALUE, oldValue, this.value);
            return this;
        }

        public PathElement build() {
            return new PathElement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PathElement> {
        public Builder index(Integer var1);

        public Builder key(String var1);

        public Builder substring(Substring var1);

        default public Builder substring(Consumer<Substring.Builder> substring) {
            return this.substring((Substring)((Substring.Builder)Substring.builder().applyMutation(substring)).build());
        }

        public Builder value(String var1);
    }
}

