/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.accessanalyzer.model.RegionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrailProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrailProperties> {
    private static final SdkField<Boolean> ALL_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("allRegions").getter(TrailProperties.getter(TrailProperties::allRegions)).setter(TrailProperties.setter(Builder::allRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allRegions").build()}).build();
    private static final SdkField<String> CLOUD_TRAIL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cloudTrailArn").getter(TrailProperties.getter(TrailProperties::cloudTrailArn)).setter(TrailProperties.setter(Builder::cloudTrailArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudTrailArn").build()}).build();
    private static final SdkField<List<String>> REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("regions").getter(TrailProperties.getter(TrailProperties::regions)).setter(TrailProperties.setter(Builder::regions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALL_REGIONS_FIELD, CLOUD_TRAIL_ARN_FIELD, REGIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean allRegions;
    private final String cloudTrailArn;
    private final List<String> regions;

    private TrailProperties(BuilderImpl builder) {
        this.allRegions = builder.allRegions;
        this.cloudTrailArn = builder.cloudTrailArn;
        this.regions = builder.regions;
    }

    public final Boolean allRegions() {
        return this.allRegions;
    }

    public final String cloudTrailArn() {
        return this.cloudTrailArn;
    }

    public final boolean hasRegions() {
        return this.regions != null && !(this.regions instanceof SdkAutoConstructList);
    }

    public final List<String> regions() {
        return this.regions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allRegions());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudTrailArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegions() ? this.regions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrailProperties)) {
            return false;
        }
        TrailProperties other = (TrailProperties)obj;
        return Objects.equals(this.allRegions(), other.allRegions()) && Objects.equals(this.cloudTrailArn(), other.cloudTrailArn()) && this.hasRegions() == other.hasRegions() && Objects.equals(this.regions(), other.regions());
    }

    public final String toString() {
        return ToString.builder((String)"TrailProperties").add("AllRegions", (Object)this.allRegions()).add("CloudTrailArn", (Object)this.cloudTrailArn()).add("Regions", this.hasRegions() ? this.regions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "allRegions": {
                return Optional.ofNullable(clazz.cast(this.allRegions()));
            }
            case "cloudTrailArn": {
                return Optional.ofNullable(clazz.cast(this.cloudTrailArn()));
            }
            case "regions": {
                return Optional.ofNullable(clazz.cast(this.regions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrailProperties, T> g) {
        return obj -> g.apply((TrailProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean allRegions;
        private String cloudTrailArn;
        private List<String> regions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrailProperties model) {
            this.allRegions(model.allRegions);
            this.cloudTrailArn(model.cloudTrailArn);
            this.regions(model.regions);
        }

        public final Boolean getAllRegions() {
            return this.allRegions;
        }

        public final void setAllRegions(Boolean allRegions) {
            this.allRegions = allRegions;
        }

        @Override
        @Transient
        public final Builder allRegions(Boolean allRegions) {
            this.allRegions = allRegions;
            return this;
        }

        public final String getCloudTrailArn() {
            return this.cloudTrailArn;
        }

        public final void setCloudTrailArn(String cloudTrailArn) {
            this.cloudTrailArn = cloudTrailArn;
        }

        @Override
        @Transient
        public final Builder cloudTrailArn(String cloudTrailArn) {
            this.cloudTrailArn = cloudTrailArn;
            return this;
        }

        public final Collection<String> getRegions() {
            if (this.regions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
        }

        @Override
        @Transient
        public final Builder regions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder regions(String ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        public TrailProperties build() {
            return new TrailProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrailProperties> {
        public Builder allRegions(Boolean var1);

        public Builder cloudTrailArn(String var1);

        public Builder regions(Collection<String> var1);

        public Builder regions(String ... var1);
    }
}

